package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.BaseController;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.common.TokenManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;

/**
 * 用户登录
 *
 * @author G
 */
@Api(tags = "用户登录")
@RestController
@RequestMapping("/login")
public class LoginController extends BaseController {

    private static Logger logger = LoggerFactory.getLogger(LoginController.class);

    @Autowired
    private HttpServletRequest request; //自动注入request

    @Autowired
    private TbCfUserInfoService tbCfUserInfoService;

    @ApiOperation(value = "注册并登录")
    @PostMapping(value = "/register")
    public Result<TbCfUserInfoVo> registerAndLogin(@ApiParam("用户信息") @RequestBody TbCfUserInfoVo tbCfUserInfoVo) {
        return tbCfUserInfoService.registerAndLogin(tbCfUserInfoVo);
    }

    @ApiOperation("登录")
    @PostMapping
    public Result<TbCfUserInfoVo> login(@ApiParam(value = "登录名")String account,
                                        @ApiParam(value = "密码") String password) {
        return tbCfUserInfoService.login(getIpAddr(request), account,password);
    }

    @ApiOperation("使用token登录")
    @GetMapping("/token")
    public Result<TbCfUserInfoVo> loginByToken() {
        return tbCfUserInfoService.loginByToken(getIpAddr(request));
    }


    @ApiOperation("第三方登录")
    @PostMapping("/thirdParty")
    public Result<TbCfUserInfoVo>  loginByThirdParty(@ApiParam("第三方账号") @RequestParam(required = false) String amount,
                                    @ApiParam("用户昵称 url编码") @RequestParam(required = false) String nick,
                                    @ApiParam("账号类型") @RequestParam(required = false) String userType) throws UnsupportedEncodingException {
        return tbCfUserInfoService.loginByThirdParty(getIpAddr(request),amount,nick,userType);
    }

}
