package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

import java.util.*;

/**
 * UnderArmour 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.UnderArmourSpider
 * @author 爱酱油不爱醋
 */
public class UnderArmourSpiderParse {

    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 解析成 Document 对象
        Document document = Jsoup.parse(content);
        // 获取商品的标题、价格、颜色名称及id、尺码名称及id
        String pId = document.select("span[class=e-color-show]").text();
        String pTitle = document.select("h3[class=commo-name]").text();
        String fullPrice = document.select("p[class=commo-price]").text().replaceAll("￥", "");
        Elements colorEle = document.select("ul[class=color-choice float-clearfix e-color-choice]").select("li");
        List<String> pColorList = colorEle.eachText();
        List<String> pColorNoList = colorEle.eachAttr("itemcode");
        Elements sizeEle = document.select("ul[class=size-choice float-clearfix  e-size-choice]").select("li");
        List<String> pSizeList = sizeEle.eachText();
        List<String> pSizeNoList = sizeEle.eachAttr("skuid");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName(PlatformEnum.UNDERARMOUR.getLabel());
        itemInfo.setShopUrl("https://www.adidas.com");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(pTitle);
        itemInfo.setPic("https://underarmour.scene7.com/is/image/Underarmour/V5-" + pId + "_FC_Main");
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        for (int i = 0; i < pColorList.size(); i++) {
            Set<ProductProp> propSet = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropName(pColorList.get(i));
            productPropColor.setPropId(pColorNoList.get(i));
            productPropColor.setImage("https://underarmour.scene7.com/is/image/Underarmour/V5-" + pColorNoList.get(i) + "_FC_Main");
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        ///////////////////////// 获取商品尺码属性 ////////////////////
        for (int i = 0; i < pSizeList.size(); i++) {
            Set<ProductProp> sizePropSet = new HashSet<>();
            ProductProp productPropSize = new ProductProp();
            productPropSize.setPropId(pSizeNoList.get(i));
            productPropSize.setPropName(pSizeList.get(i));
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }

        }
        ///////////////////////// 获取商品尺码属性 END////////////////////

        //////////////////////////////////// 获取库存与原始价 ////////////////////////////////////////////
        for (String pColorNo : pColorNoList) {
            for (String pSizeNo : pSizeNoList) {
                // 设置库存id
                String skuStr = ";" + pColorNo + ";" + pSizeNo + ";";
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                ProductSkuStock productSkuStock = new ProductSkuStock();
                OriginalPrice originalPrice = new OriginalPrice();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                // 设置：可用库存值，未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);

                // TODO 转换汇率，目前商品单位是人民币
                String originalFullPrice = SpiderUtil.exchangeRate(fullPrice);
                originalPrice.setPrice(originalFullPrice);
                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
            }
        }
        //////////////////////////////////// 获取库存与原始价 END///////////////////////////////

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.UNDERARMOUR.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
