package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.math.BigDecimal;
import java.util.*;

/**
 * PullAndBear 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.PullandbearSpider 数据爬虫
 * @author 爱酱油不爱醋
 */
public class PullAndBearSpiderParse {

    /**
     * 格式化 PullAndBear 返回数据
     * @param dataMap 主要的 json 数据
     * @param pId 商品链接的 id
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);
        // 商品基本信息
        ItemInfo itemInfo = new ItemInfo();

        // 取 bundleProductSummaries 的节点对象
        JSONObject bundleProductSummariesObj = dataMap.getJSONArray("bundleProductSummaries").getJSONObject(0);

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName(PlatformEnum.PULLANDBEAR.getLabel());
        itemInfo.setShopUrl("https://www.pullandbear.cn/cn/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(bundleProductSummariesObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        // 取 colors 数组节点
        JSONArray colorsArr = bundleProductSummariesObj.getJSONObject("detail").getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            //////////////////////////////////// 获取商品颜色与图片属性 ////////////////////////////////////////////
            Set<ProductProp> propSetColor = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            // 颜色id
            String colorNo = colorsObj.getString("id");
            productPropColor.setPropId(colorNo);
            // 颜色名
            String colorName = colorsObj.getString("name");
            productPropColor.setPropName(colorName);

            // 取 image 对象节点
            JSONObject imageObj = colorsObj.getJSONObject("image");
            // 颜色图片
            String imageUrl = "https://static.pullandbear.cn/2/photos/"
                    + imageObj.getString("url")
                    + "_2_1_8.jpg?t="
                    + imageObj.getString("timestamp");
            productPropColor.setImage(imageUrl);
            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }
            propSetColor.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSetColor);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSetColor.addAll(oldPropSet);
                productPropSet.put("颜色", propSetColor);
            }
            //////////////////////////////////// 获取商品颜色与图片属性 END ////////////////////////////////////////////


            // 取 siezes 对象数组
            JSONArray sizesArr = colorsObj.getJSONArray("sizes");
            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                ///////////////////////// 获取商品尺码属性 ////////////////////
                Set<ProductProp> sizePropSetSize = new HashSet<>();
                ProductProp productPropSize = new ProductProp();
                String size = sizesObj.getString("name");
                productPropSize.setPropName(size);
                String sizeNo = sizesObj.getString("sku");
                productPropSize.setPropId(sizeNo);
                sizePropSetSize.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSetSize);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSetSize.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSetSize);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 商品的库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，PullAndBear 未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld=new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_DOWN);

                // TODO 转换汇率，目前商品单位是人民币
                fullPrice= SpiderUtil.exchangeRate(priceNew.toString());
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.PULLANDBEAR.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
