package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.*;

/**
 * Ochirly 数据爬虫
 * @see com.diaoyun.zion.chinafrica.bis.impl.OchirlySpider
 * @author 爱酱油不爱醋
 */
public class OchirlySpiderParse {

    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        Document document = Jsoup.parse(content);
        // 获取标题
        Elements detailEle = document.select("div[class=detail]").select("div[class=desc]");
        String pTitle = detailEle.select("h5").text();
        // 获取价格
        Elements priceEle = detailEle.select("p[class=price]");
        String fullPrice = priceEle.attr("data-list-price");
        // 获取颜色id与图片
        Elements colorEle = document.select("div[class=color]").select("ul[class=clearfix]");
        List<String> imgUrlList = colorEle.select("a").eachAttr("href");
        List<String> pColorNoList = new ArrayList<>();
        for (int i = 0; i < imgUrlList.size(); i++) {
            String hrefStr = imgUrlList.get(i);
            if (hrefStr.contains("/p/mobile/")) {
                String[] spilt = hrefStr.split("/mobile/");
                pColorNoList.add(spilt[1].replaceAll(".shtml", ""));
            } else {
                pColorNoList.add(0, priceEle.attr("data-sku"));
            }
        }
        List<String> pColorList = new ArrayList<>();
        pColorList.addAll(pColorNoList);
        List<String> pImgList = colorEle.select("img").eachAttr("src");
        // 获取尺码
        Elements sizeEle = document.select("div[class=size]").select("div[class=size_contain]").select("li");
        List<String> pSizeList = new ArrayList<>();
        List<String> pSizeNoList = new ArrayList<>();
        for (Element element : sizeEle) {
            if (element.hasAttr("data-size-id")) {
                pSizeList.add(element.text());
                pSizeNoList.add(element.attr("data-size-id"));
            }
        }
        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName(PlatformEnum.OCHIRLY.getLabel());
        itemInfo.setShopUrl("www.ochirly.com");
        itemInfo.setItemId(detailEle.select("p[class=price]").attr("data-sku"));
        itemInfo.setTitle(pTitle);
        itemInfo.setPic(pImgList.get(0));
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        for (int i = 0; i < pColorList.size(); i++) {
            Set<ProductProp> propSet = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropName(pColorList.get(i));
            productPropColor.setPropId(pColorNoList.get(i));
            productPropColor.setImage(pImgList.get(i));
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        ///////////////////////// 获取商品尺码属性 ////////////////////
        for (int i = 0; i < pSizeList.size(); i++) {
            Set<ProductProp> sizePropSet = new HashSet<>();
            ProductProp productPropSize = new ProductProp();
            productPropSize.setPropId(pSizeNoList.get(i));
            productPropSize.setPropName(pSizeList.get(i));
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }

        }
        ///////////////////////// 获取商品尺码属性 END////////////////////

        //////////////////////////////////// 获取库存与原始价 ////////////////////////////////////////////
        for (String pColorNo : pColorNoList) {
            for (String pSizeNo : pSizeNoList) {
                // 设置库存id
                String skuStr = ";" + pColorNo + ";" + pSizeNo + ";";
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                ProductSkuStock productSkuStock = new ProductSkuStock();
                OriginalPrice originalPrice = new OriginalPrice();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                // 设置：可用库存值，未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);

                // TODO 转换汇率，目前商品单位是人民币
                String originalFullPrice = SpiderUtil.exchangeRate(fullPrice);
                originalPrice.setPrice(originalFullPrice);
                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
            }
        }
        //////////////////////////////////// 获取库存与原始价 END///////////////////////////////

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.OCHIRLY.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
