package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * MO&Co. 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.MocoSpider
 * @author 爱酱油不爱醋
 */
public class MocoSpiderParse {

    /**
     * 格式化返回数据
     * @param dataMap 主要的 Json 内容
     * @param pId 截取的商品 id
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 取 productData 对象节点
        JSONObject productDataObj = dataMap.getJSONObject("productData");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName("MO&Co.");
        itemInfo.setShopUrl("https://en.mo-co.com/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(productDataObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
        // 取 baseOptions 对象数组的 1 位的 options 节点数组
        JSONArray options_1_Arr = productDataObj.getJSONArray("baseOptions").getJSONObject(1).getJSONArray("options");
        List<String> colorNoList = new ArrayList<>();
        Set<ProductProp> propSet = new HashSet<>(16);
        for (int i = 0; i < options_1_Arr.size(); i++) {
            JSONObject options_1_Obj = options_1_Arr.getJSONObject(i);
            // 获取图片的路径
            String[] spiltImg = options_1_Obj.getJSONArray("variantOptionQualifiers")
                    .getJSONObject(0).getJSONObject("image").getString("url").split("_other_");
            String imageUrl = "https://mallimg.moco.com/" + pId + "_list_" + spiltImg[1];
            // 设置商品基本信息的图片
            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }
            ProductProp productPropColor = new ProductProp();
            String colorNo = options_1_Obj.getString("epoColorCode");
            colorNoList.add(colorNo);
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(options_1_Obj.getString("epoColorName"));
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        ///////////////////////// 获取商品尺码属性 ////////////////////////////////////////////////////////////////
        // 取 baseOptions 的 0 位的 options 节点数组
        List<String> sizeNoList = new ArrayList<>();
        Set<ProductProp> sizePropSet = new HashSet<>();
        JSONArray options_0_Arr = productDataObj.getJSONArray("baseOptions").getJSONObject(0).getJSONArray("options");
        for (int i = 0; i < options_0_Arr.size(); i++) {
            JSONObject options_0_Obj = options_0_Arr.getJSONObject(i);
            ProductProp productPropSize = new ProductProp();
            String sizeNo = options_0_Obj.getString("epoSizeCode");
            productPropSize.setPropId(sizeNo);
            sizeNoList.add(sizeNo);
            productPropSize.setPropName(options_0_Obj.getString("epoSizeName") +options_0_Obj.getString("sizeDescription"));
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }
            ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////
        }

        for (String colorNo : colorNoList) {
            for (String sizeNo : sizeNoList) {

                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，Zara 未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = productDataObj.getJSONObject("price").getString("value");

                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(fullPrice);
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }


        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.MOCO.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
