package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.math.BigDecimal;
import java.util.*;

/**
 * MassimoDutti 爬虫数据解析
 * @see com.diaoyun.zion.chinafrica.bis.impl.MassimoduttiSpider 数据爬虫
 * @author 爱酱油不爱醋
 */
public class MassimoDuttiSpiderParse {

    /**
     * 格式化返回数据
     * @param dataMap 主要的 json 数据
     * @param pId 商品链接的 id
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);
        // 商品基本信息
        ItemInfo itemInfo = new ItemInfo();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName(PlatformEnum.MASSIMODUTTI.getLabel());
        itemInfo.setShopUrl("https://www.massimodutti.cn/cn/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(dataMap.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        // 取 detail 节点对象
        JSONObject detailObj = dataMap.getJSONObject("detail");
        // 取 colors 节点数组
        JSONArray colorsArr = detailObj.getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            // 取 image 节点对象
            JSONObject imageObj = colorsObj.getJSONObject("image");
            // 处理商品链接
            String imageUrl = "https://static.massimodutti.cn/3/photos"
                    + imageObj.getString("url")
                    + "_2_5_16.jpg?t="
                    + imageObj.getString("timestamp");

            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }

            //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
            Set<ProductProp> propSetColor = new HashSet<>(16);
            ProductProp productPropColor = new ProductProp();
            // 颜色id
            String colorNo = colorsObj.getString("id");
            productPropColor.setPropId(colorNo);
            // 颜色名
            productPropColor.setPropName(colorsObj.getString("name"));
            // 颜色图片
            productPropColor.setImage(imageUrl);
            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }
            propSetColor.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSetColor);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSetColor.addAll(oldPropSet);
                productPropSet.put("颜色", propSetColor);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            ///////////////////////// 获取商品尺码属性 ////////////////////
            // 取 sizes 节点对象
            JSONArray sizesArr = colorsObj.getJSONArray("sizes");
            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                Set<ProductProp> sizePropSetSize = new HashSet<>(16);
                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropName(sizesObj.getString("name"));
                String sizeNo = sizesObj.getString("sku");
                productPropSize.setPropId(sizeNo);
                sizePropSetSize.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSetSize);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSetSize.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSetSize);
                }
                ///////////////////////// 获取商品尺码属性 END////////////////////

                // 库存 id
                String skuStr = ";" + colorNo + ";" + sizeNo;

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，Uniqlo 未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld = new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                BigDecimal priceNew = priceOld.divide(div, 2, BigDecimal.ROUND_HALF_UP);

                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = SpiderUtil.exchangeRate(priceNew.toString());
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.MASSIMODUTTI.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
