package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * Esprit 数据爬虫
 * @see com.diaoyun.zion.chinafrica.bis.impl.EspritSpider
 * @author 爱酱油不爱醋
 */
public class EspritSpiderParse {

    /**
     * 格式化返回数据
     * @param dataMap 主要的Json数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(JSONObject dataMap) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 取 product 下的 details 节点对象
        JSONObject detailsObj = dataMap.getJSONObject("product").getJSONObject("details");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName(PlatformEnum.ESPRIT.getLabel());
        itemInfo.setShopUrl("https://www.esprit.cn");
        itemInfo.setItemId(detailsObj.getString("code"));
        itemInfo.setTitle(detailsObj.getString("title"));
        //////////////////////////////////// 获取商品基本信息(图片下取)End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
        // 取 options 的0位的 value 节点数组
        JSONArray values_0_Arr = detailsObj.getJSONArray("options").getJSONObject(0).getJSONArray("values");
        List<String> colorNoList = new ArrayList<>();
        Set<ProductProp> propSet = new HashSet<>(16);
        for (int i = 0; i < values_0_Arr.size(); i++) {
            JSONObject values_0_Obj = values_0_Arr.getJSONObject(i);
            // 获取图片路径
            String imageUrl = values_0_Obj.getJSONArray("images").getJSONObject(0).getString("url");
            // 设置商品基本信息的图片
            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }
            ProductProp productPropColor = new ProductProp();
            String colorNo = values_0_Obj.getString("code");
            colorNoList.add(colorNo);
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(values_0_Obj.getString("displayName"));
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        ///////////////////////// 获取商品尺码属性 ////////////////////////////////////////////////////////////////
        // 取 options 的 1 位的 value 节点数组
        List<String> sizeNoList = new ArrayList<>();
        Set<ProductProp> sizePropSet = new HashSet<>();
        JSONArray values_1_Arr = detailsObj.getJSONArray("options").getJSONObject(1).getJSONArray("values");
        for (int i = 0; i < values_1_Arr.size(); i++) {
            JSONObject values_1_Obj = values_1_Arr.getJSONObject(i);
            ProductProp productPropSize = new ProductProp();
            String sizeNo = values_1_Obj.getString("code");
            productPropSize.setPropId(sizeNo);
            sizeNoList.add(sizeNo);
            productPropSize.setPropName(values_1_Obj.getString("displayName"));
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }
            ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////
        }

        for (String colorNo : colorNoList) {
            for (String sizeNo : sizeNoList) {

                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                productResponse.setStockFlag(true);
                List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                // 设置：可用库存值，Zara 未有可用的库存数据
                productSkuStock.setSellableQuantity(999);
                // 设置：库存对应的id
                productSkuStock.setSkuStr(skuStr);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                // 获取商品的原始价
                String fullPrice = detailsObj.getJSONObject("salePrice").getString("amount");

                // TODO 转换汇率，目前商品单位是人民币
                fullPrice = exchangeRate(fullPrice);
                originalPrice.setPrice(fullPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);

                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.ESPRIT.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
