package com.diaoyun.zion.master.util.spider;

import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.*;

import static com.diaoyun.zion.master.util.spider.SpiderUtil.exchangeRate;

/**
 * Adidas 数据爬虫
 * @see com.diaoyun.zion.chinafrica.bis.impl.AdidasSpider
 * @author 爱酱油不爱醋
 */
public class AdidasSpiderParse {

    /**
     * 格式化返回数据
     * @param content 主要的页面数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(String content, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 属性：Zara 的商品属性有颜色、尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        // 原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        // 促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 库存
        DynStock dynStock = new DynStock();
        // 其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);

        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        // 获取商品的价格、颜色、标题、图片、尺码属性
        String fullPrice = document.select("input[id=salePrice]").attr("value");
        String pColor = document.select("input[id=colorDisPaly]").attr("value");
        String pTitle = document.select("input[id=itemTitle]").attr("value");
        String pImg = document.select("input[id=shoppingcartpic]").attr("value");
        List<String> pSizeList = document.select("div[class=overview product-size]")
                .select("ul").select("li").eachText();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.setShopName(PlatformEnum.ADIDAS.getLabel());
        itemInfo.setShopUrl("https://www.adidas.com");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(pTitle);
        itemInfo.setPic(pImg);
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        for (int i = 0; i < pSizeList.size(); i++) {
            // 库存对应的id(颜色id + 尺码id)
            String skuStr = ";" + pId + ";" + pSizeList.get(i) + ";";

            ///////////////////////// 获取商品尺码属性 ////////////////////
            Set<ProductProp> sizePropSet = new HashSet<>();
            ProductProp productPropSize = new ProductProp();
            productPropSize.setPropId(pSizeList.get(i));
            productPropSize.setPropName(pSizeList.get(i));
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }
            ///////////////////////// 获取商品尺码属性 END////////////////////

            //////////////////////////////////// 获取库存 ////////////////////////////////////////////
            // 设置：商品包含库存信息
            productResponse.setStockFlag(true);
            List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
            if (productSkuStockList == null) {
                productSkuStockList = new ArrayList<>();
            }
            ProductSkuStock productSkuStock = new ProductSkuStock();
            // 设置：可用库存值，Zara 未有可用的库存数据
            productSkuStock.setSellableQuantity(999);
            // 设置：库存对应的id
            productSkuStock.setSkuStr(skuStr);
            productSkuStockList.add(productSkuStock);
            dynStock.setProductSkuStockList(productSkuStockList);
            //////////////////////////////////// 获取库存 END/////////////////////////////////////////

            //////////////////////////////////// 获取原始价 //////////////////////////////////
            OriginalPrice originalPrice = new OriginalPrice();
            // 获取商品的原始价
            // TODO 转换汇率，目前商品单位是人民币
            String originalFullPrice = exchangeRate(fullPrice);
            originalPrice.setPrice(originalFullPrice);
            productResponse.setPrice(originalFullPrice);
            productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
            originalPrice.setSkuStr(skuStr);
            originalPriceList.add(originalPrice);
            //////////////////////////////////// 获取原始价 END///////////////////////////////
        }

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        Set<ProductProp> propSet = new HashSet<>(16);
        ProductProp productPropColor = new ProductProp();
        // 颜色描述
        productPropColor.setPropId(pId);
        productPropColor.setPropName(pColor);
        productPropColor.setImage(pImg);
        propSet.add(productPropColor);
        if (productPropSet.get("颜色") == null) {
            productPropSet.put("颜色", propSet);
        } else {
            Set<ProductProp> oldPropSet = productPropSet.get("颜色");
            propSet.addAll(oldPropSet);
            productPropSet.put("颜色", propSet);
        }
        //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

        // 按照一下顺序进行 json 数据的填充
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.ADIDAS.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
