package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.CouponItem;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfIssueCouponEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfIssueCouponEntityExtends;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 优惠券发放保存表Service接口
 *
 * @author lipengjun
 * @date 2019-10-24 17:30:10
 */
public interface TbCfIssueCouponService {

    /**
     * 根据主键查询实体
     *
     * @param
     * @return 实体
     */
    TbCfIssueCouponEntity queryObject(String couponIssuetableId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfIssueCouponEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     *
     * @param tbCfCouponIssue
     * @param tbCfIssueCoupon 实体
     * @param userId
     * @return 保存条数
     */
    int save(TbCfIssueCouponEntity issueCouponEntity);
    /**
     * 根据主键更新实体
     *
     * @param tbCfIssueCoupon 实体
     * @return 更新条数
     */
    int update(TbCfIssueCouponEntity tbCfIssueCoupon);

    /**
     * 根据主键删除
     *
     * @param couponIssuetableId
     * @return 删除条数
     */
    int delete(String couponIssuetableId);

    /**
     * 根据主键批量删除
     *
     * @param couponIssuetableIds
     * @return 删除条数
     */
    int deleteBatch(String[] couponIssuetableIds);

    Result<CouponItem> queryCouponByUserId(String userId);


}
