package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.SpiderService;
import com.diaoyun.zion.chinafrica.vo.DetailParamVo;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.*;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 爬取网络相关数据Controller
 *
 * @author G
 * @date 2019-08-22 15:51:16
 */
@Api(tags = "数据爬虫")
@RestController
@RequestMapping("/spider")
public class SpiderController {

    @Autowired
    private SpiderService spiderService;

    @ApiOperation("获取商品详情")
    @PostMapping("/item/detail")
    public Result getItemDetail(@ApiParam("targetUrl 需要先进行url编码") @RequestBody DetailParamVo detailParamVo) throws InterruptedException, ExecutionException, URISyntaxException, IOException, TimeoutException {
        String targetUrl= URLDecoder.decode(detailParamVo.getTargetUrl(), Consts.UTF_8.name());
        JSONObject itemMap=spiderService.getItemDetail(targetUrl);
        return new Result<>(itemMap,"商品规格信息");
    }


}
