package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.spider.ZaraSpiderParse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Zara西班牙时尚品牌数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("zaraSpider")
public class ZaraSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Massimo Dutti 商品详情页Url
     */
    private static final String ZARA_URL = "https://www.zara.cn/cn/zh/";

    /**
     * Massimo Dutti 数据爬虫
     * @see com.diaoyun.zion.chinafrica.service.impl.SpiderServiceImpl# 修改商品详情页路径
     * @see ZaraSpiderParse#getJsonData 返回截取到的主要商品数据
     * @see ZaraSpiderParse#formatProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        JSONObject resultObj;
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ZARA.getValue());
        resultObj = ZaraSpiderParse.getJsonData(content);
        ProductResponse productResponse = ZaraSpiderParse.formatProductResponse(resultObj);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }


}
