package com.diaoyun.zion.chinafrica.bis.impl;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;

import java.util.HashMap;
import java.util.Map;

/**
 * stripe支付相关方法
 */
public class StripePay {

    /**
     * 发起支付，默认使用美元支付
     * @param amount 货币的最小单位，比如美元，传入1000，就是1000美分，10美元
     * @param sk
     * @param token
     * @return
     */
    public static Charge createCharge(Integer amount,String sk,String token) throws StripeException {
        Stripe.apiKey = sk;
        Map<String, Object> chargeParams = new HashMap<String, Object>();
        chargeParams.put("amount", amount);
        chargeParams.put("currency", "usd");
        // 会出现在付款后页面
        /** chargeParams.put("description", "Charge for jenny.rosen@example.com");*/
        chargeParams.put("source",token);
        return Charge.create(chargeParams);
    }
}
