package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.spider.OchirlySpiderParse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * OchirlySpider 数据爬虫
 * TODO 存在"暂时无货"的判断
 * @author 爱酱油不爱醋
 */
@Component("ochirlySpider")
public class OchirlySpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * OchirlySpider 商品详情页Url
     */
    private static final String URBANREVIVO_URL = "http://www.ochirly.com.cn/p/mobile/";

    /**
     * 爬虫数据返回
     * @see OchirlySpiderParse#formatProductResponse 格式化方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     * @see
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.UNDERARMOUR.getValue());
        ProductResponse productResponse = OchirlySpiderParse.formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        // 翻译
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

}