package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.spider.MocoSpiderParse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * MO&Co. 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("mocoSpider")
public class MocoSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * MO&Co. 商品详情页Url
     */
    private static final String MOCO_URL = "https://www.moco.com/moco/zh/p/";

    /**
     * MO&Co. 数据爬虫
     * @see MocoSpiderParse#formatProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中的商品id
        String[] spilt = targetUrl.split("/p/");
        String pId = spilt[1];
        targetUrl = "https://www.moco.com/moco/zh/ajax/variant/" + pId;
        // 通过接口获取主要商品的内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.MOCO.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        // 格式化数据
        ProductResponse productResponse = MocoSpiderParse.formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        // 翻译数据
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }


}
