package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.spider.MassimoDuttiSpiderParse;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Massimo Dutti 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("massimoduttiSpider")
public class MassimoduttiSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * Massimo Dutti 商品详情页Url
     */
    private static final String MASSIMO_DUTTI_URL = "https://www.massimodutti.cn/cn/";

    /**
     * Massimo Dutti 数据爬虫
     * @see MassimoDuttiSpiderParse#formatProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中商品的 id
        String[] split = targetUrl.split(".html");
        String pUrl = split[0];
        int pChar = pUrl.lastIndexOf("p");
        String pId = pUrl.substring(pChar + 1);
        String dataUrl = "https://www.massimodutti.cn/itxrest/2/catalog/store/35009478/30359500/category/0/product/" + pId + "/detail?languageId=-7&appId=1";
        String content = HttpClientUtil.getContentByUrl(dataUrl, PlatformEnum.MASSIMODUTTI.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = MassimoDuttiSpiderParse.formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

}
