package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.spider.AdidasSpiderParse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * Adidas 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("adidasSpider")
public class AdidasSpider implements IItemSpider {

    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Adidas 商品详情页 Url
     */
    private static final String ADIDAS_URL="https://www.adidas.com.cn/item";

    /**
     * Adidas 数据爬虫
     * @see AdidasSpiderParse#formatProductResponse 格式化数据方法
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取商品的 id
        int labelHeadIndex = targetUrl.indexOf("item/");
        int labelTailIndex = targetUrl.lastIndexOf("?");
        String pId = targetUrl.substring(labelHeadIndex, labelTailIndex).replace("item/", "");
        // 对应的商品数据接口
        targetUrl = "https://www.adidas.com.cn/item/othercolor?itemCode=" + pId;
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.ADIDAS.getValue());
        // 格式化商品数据
        ProductResponse productResponse = AdidasSpiderParse.formatProductResponse(content, pId);
        JSONObject resultJson = JSONObject.fromObject(productResponse);
        // 翻译
        TranslateHelper.translateProductResponse(resultJson);
        return resultJson;
    }

}
