package com.diaoyun.zion.chinafrica.bis;

import net.sf.json.JSONObject;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 商品爬虫接口
 *
 * @author G
 */
public interface IItemSpider {

    /**
     * 爬取商品数据
     * @param targetUrl 商品详情页路径
     * @return 返回格式化及翻译后的 Json 数据
     * @throws InterruptedException 被打断异常
     * @throws IOException IO异常
     * @throws ExecutionException 运行时异常
     * @throws URISyntaxException 语法异常
     * @throws TimeoutException 超时异常
     */
    JSONObject captureItem(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException;

}
