# 爬虫规范
## 添加新爬虫至项目规范
- 1.实现爬虫接口并重写 **captureItem()** 方法
    - [IItemSpider.java](../src/main/java/com/diaoyun/zion/chinafrica/bis/IItemSpider.java)
- 2.声明为 Spring 的组件
    - 如"Nike"的```@Component("nikeItemSpider")```
- 3.在**爬虫枚举**中声明该平台的枚举
    - [PlatformEnum.java](../src/main/java/com/diaoyun/zion/chinafrica/enums/PlatformEnum.java)
    - 如"Nike"的```NIKE("NIKE", "nike")```
- 4.在**商品爬虫工厂类**中声明该平台的实现类
    - [ItemSpiderFactory.java](../src/main/java/com/diaoyun/zion/chinafrica/factory/ItemSpiderFactory.java)
- 5.在**商品爬虫Service类**中声明该平台的爬虫和商品的详情路径
    - [SpiderServiceImpl.java](../src/main/java/com/diaoyun/zion/chinafrica/service/impl/SpiderServiceImpl.java)
- 6.在**Json工具类**中编写获取爬虫主要的商品数据
    - [JsoupUtil.java](../src/main/java/com/diaoyun/zion/master/util/JsoupUtil.java)
- 7.在**爬虫工具类**中编写爬虫返回json数据规范
    - [SpiderServiceImpl.java](../src/main/java/com/diaoyun/zion/master/util/SpiderUtil.java)
    - 爬虫数据封装类：[ProductResponse.java](../src/main/java/com/diaoyun/zion/chinafrica/vo/ProductResponse.java)
- 8.调用**翻译方法**翻译爬取回来的数据
    - [translateProductResponse(JSONObject resultObj)](../src/main/java/com/diaoyun/zion/master/util/TranslateHelper.java)

> 注意爬虫的命名

# 需要爬取的购物网站
### [Pull and Bear](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/PullandbearSpider.java)
- 主页：https://www.pullandbear.cn/cn/%E5%A5%B3%E5%A3%AB-c1030204574.html
- 命名：pullandbear
- 爬虫进度：**已完成**
    - 有反爬机制，有时会直接失效，不稳定
### [Gap](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/GapItemSpider.java)
- 主页：https://www.gap.cn/
- 命名：gap
- 爬虫进度：**已完成**
### [Zara](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/ZaraSpider.java)
- 主页：https://www.zara.cn/cn
- 命名：zara
- 爬虫进度：**已完成**
### [Uniqlo(优衣库)](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/UniqloSpider.java)
- 主页：https://www.uniqlo.cn/UNIQLO_U19FW_MEN.html
- 命名：uniqlo
- 爬虫进度：**已完成**
    - 可能存在的缺陷：
        - 图片的路径是直接下载图片
### [Nike(耐克)](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/NikeItemSpider.java)
- 主页：https://www.nike.com/cn
- 命名：nike
- 爬虫进度：**已完成**

### [Adidas(阿迪达斯)](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/AdidasSpider.java)
- 主页：https://www.adidas.com.cn/
- 命名：adidas
- 爬虫进度：**已完成**

### H&M
- 主页：https://www2.hm.com/zh_cn/
- 命名：hm
- 爬虫进度：已能获取到数据
    - Json被做了一些难处理的封装，现有工具无法将其转换为Json格式
    - 商品颜色通过商品详情页的url来区分，暂未找到规律
### LiLy
- 主页：http://www.lily.sh.cn/webapp/wcs/stores/servlet/lilystore
- 命名：lily
- 爬虫进度：已完成分析，待处理
    - 数据嵌在HTML中，数据较难处理，延后爬取
### Eifini
- 主页：https://eifini.tmall.com/ 
- 命名：eifini
- 爬虫进度：未知方法
    - 该购物网站是天猫代理的商城
### [Urban Revivo](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/UrbanRevivoSpider.java)
- 主页：http://www.ur.cn/index.html
- 命名：urbanrevivo
- 爬虫进度：**已完成**
    - 商品案例：http://wap.ur.com.cn/product/detail?productColorId=ff8080816dbb693e016dfd58f27c45d9
    - 数据接口：http://wap.ur.com.cn/product/product/detail?id=ff8080816dbb693e016dfd58f27c45d9
### Aber Crombie & Fitch
- 主页：https://www.abercrombie.cn/zh_CN/home
- 命名：abercrombie
- 爬虫进度：存在反爬机制
    - 链接做了编码形式的反爬机制
    
### [Under Armour(安德玛)](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/UnderArmourSpider.java)
- 主页：https://www.underarmour.cn/
- 命名：ur
- 爬虫进度：**已完成**

### Converse(匡威)
- 主页：https://www.converse.com.cn/
- 命名：converse
- 爬虫进度：存在反爬机制
    - 存在反向代理的反爬机制，暂无法爬取
    
### [Ochirly](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/OchirlySpider.java)
- 主页：http://www.ochirly.com.cn/SALE/list.shtml
- 命名：ochirly
- 爬虫进度：**已完成**

### [Esprit](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/EspritSpider.java)
- 主页：https://www.esprit.cn/
- 命名：esprit
- 爬虫进度：**已完成**

### [Levi(李维斯)](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/LeviSpider.java)
- 主页：https://www.levi.com.cn/sale#page=3
- 命名：levi
- 爬虫进度：**已完成**
### [MO&Co.](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/MocoSpider.java)
- 主页：https://www.moco.com/moco/zh/c/BS_DISCOUNT
- 命名：moco
- 爬虫进度：**已完成**
### [Massimo Dutti](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/MassimoduttiSpider.java)
- 主页：https://www.massimodutti.cn/cn/男装/季末折扣/休闲西装-c1745921.html
- 命名：massimodutti
- 爬虫进度：**已完成**
    - 数据来源
        - 商品详情：https://www.massimodutti.cn/cn/%E5%A5%B3%E8%A3%85/%E7%B3%BB%E5%88%97/%E8%A1%AC%E8%A1%AB%E5%92%8C%E7%BD%A9%E8%A1%AB/%E8%A1%AC%E8%A1%AB/%E6%BB%91%E9%9B%AA%E9%A3%8E%E7%B3%BB%E5%88%97%E9%A5%B0%E5%8F%A3%E8%A2%8B%E8%A1%AC%E8%A1%AB-c1718602p8730105.html?colorId=420&categoryId=1718602
        - 数据接口：https://www.massimodutti.cn/itxrest/2/catalog/store/35009478/30359500/category/0/product/8730105/detail?languageId=-7&appId=1

### COACH
- 主页：https://china.coach.com/women.html
- 命名：coach
- 爬虫进度：

### Revolve
- 主页：https://www.revolve.com/wrangler/br/57f1a1/?utm_source=baidu&utm_medium=cpc&utm_campaign=intl_P_cn-d-Wrangler
- 命名：reolve
- 爬虫进度：

### Vans
- 主页：https://vans.com.cn/gallery-index---0---36.html
- 命名：Vans

### 待选爬虫网站：
    - 21，https://vans.com.cn/gallery-index---0---36.html 
    - 22，https://zarahome.tmall.com/?spm=a1z10.3-b-s.1997427721.d4918089.7b872e00zWrHhi
    - 23，https://oysho.tmall.com/ (SPORT WEAR)
    - 24，https://stradivarius.tmall.com/ (ZARA GROUP )
    - 25，https://www.maje.cn/home?utm_campaign=maje-competitor-u&utm_content=competitor-ph&utm_medium=cpc&utm_source=baidu&utm_term=marc%e6%98%af%e4%bb%80%e4%b9%88%e7%89%8c%e5%ad%90
    - 26，https://www.gucci.cn/zh/?utm_source=baiducpc_cn&utm_medium=cpc&utm_term=Title2&utm_content=URL_E-commerce_HomePage&utm_campaign=BD_PC_URL_E-commerce&src=Baidu&medium=PPC&Network=1&kw=133669705534&ad=31701433238&ag_kwid=23329-4-575c9bdeeef5d28f.9143bf3bdcd3718c
    - 27，https://cn.burberry.com/?utm_source=Baidu&utm_medium=cpc&utm_campaign=cn_brandzone_pc_aw19_aw_20190822&utm_term=brandzone&utm_content=title&gclid=CPf87uqgwOQCFQ4XvAodUzMEkA&gclsrc=ds
    - 28，https://www.prada.com/cn/zh.html?utm_source=baidu&utm_medium=pcbrandzone&utm_campaign=2017-12-19_e-commerce 
    - 29，https://www.fendi.cn/?utm_source=Baidu&utm_medium=PC&utm_campaign=NewBrand%20Pure&utm_content=B_Site
    - 30，https://www.vmall.com/huawei?cid=78140 (huawei)
    - 31，http://inside.chanel.com/zh/chanel-goes-west
    - 32，https://www.apple.com/cn/shop/buy-iphone/iphone-xr
    - 33，https://www.louisvuitton.cn/zhs-cn/homepage?campaign=sem_CN_ZHS_BA_EC_BZON_PC_Valuable_H1_homepage

# 爬虫步骤
## 目的
帮助不能使用国内购物平台的用户进行**代购服务**，而要进行代购，就要**帮助他们下单**。为了帮助用户下单，很重要的
一步就是要**获取平台的商品的规格**；让用户可以在浏览的时候，可以让他们在我们app上选择相应规格的商品
## 分析页面数据
首先要明白的是：App页面传给我们的只有原始商品的连接，为了获取页面上的商品信息有两种方式：
- 分析**页面**构成，例如：Zara 爬虫
    - 在某个地方会存在json数据的传递
    - 嵌套在Html页面中的各种数据
- 分析页面调用接口后的返回数据，例如：Uniqlo 优衣库爬虫

## 页面中存在Json数据传递的--示例：Zara
### 1.随便点击一个商品详情页<br>
![](img/zara商品页.png)
### 2.通过商品的一些关键信息进行搜索<br>
![](img/zara关键子搜索.png)
### 3.检索信息(关键步骤)
- (1) **感觉可能**这是相关的商品详情信息，而且是**Json格式**的数据
- (2) 通过[Json格式化工具：http://www.bejson.com/jsonviewernew/](http://www.bejson.com/jsonviewernew/)来格式化Json数据
- (3) 再次通过关键搜索诸如**价格**、**尺寸**等，检查数据是否是我们想要的、是否是完整的，如果不是重复(1)、(2)步骤继续搜寻<br>
![](img/zara截取的数据.png)
- (4) 确认完数据后查看该 json 的id名是什么<br>
    - Zara传递的这个Json的id是**dataLayer**<br>
    ![](img/Zara爬虫05.png)
### 4.截取数据封装数据
- 新键该爬虫，请看**添加新爬虫至项目规范**
- [ZaraSpider.java](../src/main/java/com/diaoyun/zion/chinafrica/bis/impl/ZaraSpider.java)
- 如何处理数据详情请看爬虫的@see注释

# Java 处理爬取的数据
## Json 数据的处理

## HTML 数据的处理


# 爬虫Json数据返回规范

## 封装类 [ProductResponse](../src/main/java/com/diaoyun/zion/chinafrica/vo/ProductResponse.java)
封装类的属性已经说明了爬虫需要爬取的数据有哪一些
- skuId 标识规范：;[颜色id];[尺寸id];
    - 该 id 通过爬取**颜色**与**尺寸**对应数据时获取到的唯一标识
    - 用于标识**库存**与**价格**

### 按照 Nike 爬虫返回的数据进行封装
│── data 数据<br>
│ │── dynStock 库存<br>
│ ││─── productSkuStockList 库存数量的集合<br>
│ │││──── sellableQuantity 库存数量<br>
│ │││──── skuStr 库存对应尺码（或尺码）<br>
│ ││─── sellableQuantity 库存数量<br>
│ │── itemInfo 基本信息<br>
│ ││─── itemId 商品id<br>
│ ││─── pic 图片<br>
│ ││─── shopName 平台名称<br>
│ ││─── shopUrl 商品路径<br>
│ ││─── title 标题<br>
│ │── originalPriceList 原始价<br>
│ ││─── price 价格<br>
│ │── 自定义属性名<br>
│ │── platform 枚举类型<br>
│ │── 自定义属性名<br>
│ ││─── image 图片<br>
│ ││─── propId 属性id<br>
│ ││─── propName 属性名<br>
│ ││─── translate 翻译结果<br>
│ │── price 价格<br>
│ │── productPropSet 属性<br>
│ │── promotionFlag 是否包含促销价格<br>
│ │── promotionList 若促销价格为 true 则添加促销价格<br>
│ │── propFlag 是否包含商品商品属性<br>
│ │── salePrice 促销一口价<br>
│ │── stockFlag 是否包含库存信息<br>
│── code 1 <br>
│── message "商品规格信息" <br>

#### Nike 返回的 json 数据示范
```json
{
  "data": {
    "dynStock": {     // 库存
      "productSkuStockList": [  // 库存的集合 
        {
          "sellableQuantity": 999,  // 库存数量
          "skuStr": ";AO4568-600;customizeId_39EU;" // 商品型号（或对应尺码）
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-600;customizeId_40EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-600;customizeId_44.5EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-600;customizeId_45EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-600;customizeId_46EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_36EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_36.5EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_37.5EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_38EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_38.5EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_39EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_44EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_45EU;"
        },
        {
          "sellableQuantity": 999,
          "skuStr": ";AO4568-300;customizeId_46EU;"
        }
      ],
      "sellableQuantity": 9999
    },
    "itemInfo": { // 基本信息
      "itemId": "", // 商品信息
      "pic": "https://c.static-nike.com/a/images/t_default/oswylvgs8k4lipvwtxsz/zoomx-vaporfly-next-男-女跑步鞋-SJldS6.jpg", // 商品图片
      "shopName": "NIKE", // 商店名称
      "shopUrl": "https://www.nike.com/cn/",  // 商品路径
      "title": "Nike ZoomX Vaporfly NEXT% 男/女跑步鞋-耐克(Nike)中国官网"  // 商品的标题
    },
    "originalPriceList": [  // 原始价
      {
        "price": "296.06",  // 价格
        "skuStr": ";AO4568-600;customizeId_36EU;" // 对应尺码
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_36.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_37.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_38EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_38.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_39EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_40EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_40.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_41EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_42EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_42.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_43EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_44EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_44.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_45EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-600;customizeId_46EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_36EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_36.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_37.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_38EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_38.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_39EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_40EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_40.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_41EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_42EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_42.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_43EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_44EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_44.5EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_45EU;"
      },
      {
        "price": "296.06",
        "skuStr": ";AO4568-300;customizeId_46EU;"
      }
    ],
    "platform": "nike", // 商品来源，对应枚举类
    "price": "296.06",  // 商品价格
    "productPropSet": { // 商品属性，如颜色、尺码
      "颜色": [
        {
          "image": "https://c.static-nike.com/a/images/t_default/og3mqyqi9ckvpz43yp3u/zoomx-vaporfly-next-男-女跑步鞋-SJldS6.jpg", // 图片
          "propId": "AO4568-600", // 颜色对应的型号
          "propName": "爆炸粉/冰番石榴色/黑",  // 颜色名称
          "translate": "Explosive powder / pomegranate color / black" // 翻译的结果
        },
        {
          "image": "https://c.static-nike.com/a/images/t_default/oswylvgs8k4lipvwtxsz/zoomx-vaporfly-next-男-女跑步鞋-SJldS6.jpg",
          "propId": "AO4568-300",
          "propName": "电子绿/冰番石榴色/黑",
          "translate": "Electronic green / pomegranate color / black"
        }
      ],
      "尺码": [
        {
          "image": "",  // 图片
          "propId": "customizeId_40EU", // 尺码值
          "propName": "EU 40",  // 尺码值
          "translate": "EU 40"  // 翻译结果
        },
        {
          "image": "",
          "propId": "customizeId_42EU",
          "propName": "EU 42",
          "translate": "EU 42"
        },
        {
          "image": "",
          "propId": "customizeId_44.5EU",
          "propName": "EU 44.5",
          "translate": "EU 44.5"
        },
        {
          "image": "",
          "propId": "customizeId_41EU",
          "propName": "EU 41",
          "translate": "EU 41"
        },
        {
          "image": "",
          "propId": "customizeId_37.5EU",
          "propName": "EU 37.5",
          "translate": "EU 37.5"
        },
        {
          "image": "",
          "propId": "customizeId_40.5EU",
          "propName": "EU 40.5",
          "translate": "EU 40.5"
        },
        {
          "image": "",
          "propId": "customizeId_42.5EU",
          "propName": "EU 42.5",
          "translate": "EU 42.5"
        },
        {
          "image": "",
          "propId": "customizeId_44EU",
          "propName": "EU 44",
          "translate": "EU 44"
        },
        {
          "image": "",
          "propId": "customizeId_43EU",
          "propName": "EU 43",
          "translate": "EU 43"
        },
        {
          "image": "",
          "propId": "customizeId_46EU",
          "propName": "EU 46",
          "translate": "EU 46"
        },
        {
          "image": "",
          "propId": "customizeId_45EU",
          "propName": "EU 45",
          "translate": "EU 45"
        },
        {
          "image": "",
          "propId": "customizeId_36EU",
          "propName": "EU 36",
          "translate": "EU 36"
        },
        {
          "image": "",
          "propId": "customizeId_36.5EU",
          "propName": "EU 36.5",
          "translate": "EU 36.5"
        },
        {
          "image": "",
          "propId": "customizeId_38EU",
          "propName": "EU 38",
          "translate": "EU 38"
        },
        {
          "image": "",
          "propId": "customizeId_39EU",
          "propName": "EU 39",
          "translate": "EU 39"
        },
        {
          "image": "",
          "propId": "customizeId_38.5EU",
          "propName": "EU 38.5",
          "translate": "EU 38.5"
        }
      ]
    },
    "promotionFlag": false, // 是否包促销价格 true 有促销价格，false\null没有促销价格
    "promotionList": [
      
    ],
    "propFlag": true, // 是否包含商品属性，有些商品没有属性
    "salePrice": "",  // 促销一口价
    "stockFlag": true // 是否包含库存信息 有些商品没有库存信息，可以当作是有货 true 有库存信息，false没有
  },
  "code": 1,
  "message": "商品规格信息"
}
```