import request from '@/utils/request'

//获取菜谱类型列表
export function getRecipeTypeList() {
  return request({
    url: '/recipeType/getRecipeTypeList',
    method: 'get',
  })
}

//添加菜谱类型
export function addRecipeType(data) {
  return request({
    url: '/recipeType/addRecipeType',
    method: 'post',
    data: data
  })
}

//更新菜谱类型
export function updateRecipeType(data) {
  return request({
    url: '/recipeType/updateRecipeType',
    method: 'put',
    data: data
  })
}

//删除菜谱类型
export function delRecipeType(ids) {
  return request({
    url: '/recipeType/delRecipeType/'+ids,
    method: 'delete'
  })
}

//获取菜谱类型根据id
export function getRecipeTypeById(id) {
  return request({
    url: '/recipeType/getRecipeTypeById/'+id,
    method: 'get'
  })
}
