import request from '@/utils/request'

//获取菜谱类型列表
export function getRecipeType() {
  return request({
    url: '/recipeWeek/getRecipeType',
    method: 'get',
  })
}

//获取菜谱列表
export function getRecipeList() {
  return request({
    url: '/recipeWeek/getRecipeList',
    method: 'get',
  })
}


//根据星期获取菜谱
export function getRecipeByWeek(week) {
  return request({
    url: '/recipeWeek/getRecipeByWeek/'+week,
    method: 'get',
  })
}
//根据星期更新菜谱
export function updateRecipeWeek(week,data) {
  return request({
    url: '/recipeWeek/updateRecipeWeek/'+week,
    method: 'post',
    data:data
  })
}
