import request from '@/utils/request'

// 查询所有的主贴列表
export function getList(query) {
  return request({
    url: '/postBack/getPostManList',
    method: 'get',
    params: query
  })
}


// 根据主贴查询跟帖
export function getPostMain(id) {
    return request({
      url: '/postBack/getPostFollowList/' + id,
      method: 'get'
    })
}


// 删除主贴数据
export function delPostMain(id) {
  return request({
    url: '/postBack/delPostMainById/' + id,
    method: 'get'
  })
}

// 删除主贴数据
export function delPostFollow(id) {
  return request({
    url: '/postBack/delPostFollowById/' + id,
    method: 'get'
  })
}

