import request from '@/utils/request'

// 查询客餐申请列表
export function listApply(query) {
  return request({
    url: '/formalDishesApply/allList',
    method: 'get',
    params: query
  })
}

// 查询客餐申请详细
export function getApply(id) {
  return request({
    url: '/formalDishesApply/getApplyById/' + id,
    method: 'get'
  })
}

// 新增客餐申请
export function addApply(data) {
  return request({
    url: '/formalDishesApply/apply',
    method: 'post',
    data: data
  })
}

// 修改客餐申请
export function updateApply(data) {
  return request({
    url: '/formalDishesApply/examine',
    method: 'put',
    data: data
  })
}

// 修改客餐申请
export function reject(data) {
  return request({
    url: '/formalDishesApply/reject',
    method: 'put',
    data: data
  })
}

// 删除客餐申请
export function delApply(id) {
  return request({
    url: '/system/apply/' + id,
    method: 'delete'
  })
}

// 导出客餐申请
export function exportApply(query) {
  return request({
    url: '/formalDishesApply/export',
    method: 'get',
    params: query
  })
}
