import request from '@/utils/request'

//get all canteen list
export function getList(query) {
  return request({
    url: '/canteen/canteenList',
    method: 'get',
    params: query
  })
}

//add
export function addCanteen(data) {
  return request({
    url: '/canteen/addCanteen',
    method: 'post',
    data:data
  })
}

//del
export function delCanteen(id) {
  return request({
    url: '/canteen/delCanteen/'+id,
    method: 'delete',
  })
}

//get canteen by id
export function getCanteenById(id) {
  return request({
    url: '/canteen/getCanteenById/'+id,
    method: 'get',
  })
}


//updateCanteen
export function updateCanteen(data) {
  return request({
    url: '/canteen/updateCanteen',
    method: 'put',
    data:data
  })
}
