import request from '@/utils/request'

//get all announcement list
export function getList(query) {
  return request({
    url: '/announcement/announcementList',
    method: 'get',
    params: query
  })
}

// get current announcement which have been selected
export function getCurrent() {
  return request({
    url: '/announcement/getCurrentAnnouncement',
    method: 'get'
  })
}

// add announcement
export function addAnnouncement(data) {
  return request({
    url: '/announcement/addAnnouncement',
    method: 'post',
    data: data
  })
}

// get announcement by condition
export function getAnnouncement(data) {
  return request({
    url: '/announcement/getAnnouncement',
    method: 'post',
    data: data
  })
}

// update announcement
export function updateAnnouncement(data) {
  return request({
    url: '/announcement/updateAnnouncement',
    method: 'post',
    data: data
  })
}

//delete announce
export function delAnnouncement(ids) {
  return request({
    url: '/announcement/delAnnouncement/'+ids,
    method: 'delete'
  })
}

//activate announcement
export function activateAnnouncement(ids) {
  return request({
    url: '/announcement/activateAnnouncement/'+ids,
    method: 'get'
  })
}

