function showPosition(position){
            console.log("Latitude: " + position.coords.latitude +"<br />Longitude: " + position.coords.longitude);
            localStorage.setItem('position_lat',position.coords.latitude);
            localStorage.setItem('position_long',position.coords.longitude);
            var latlon = position.coords.latitude +','+position.coords.longitude;
            //baidu 
            var urlBaidu = "http://api.map.baidu.com/geocoder/v2/?ak=19b2aeEBWc3g254sRTESzrbAG4ObB92l&callback=renderReverse&location="+latlon+"&output=json&pois=0"; 
            var urlGoogle = 'http://maps.google.cn/maps/api/geocode/json?latlng='+latlon+'&language=CN'; 
 
            _self.$http.jsonp(urlBaidu).then(function(res){
                var res = JSON.parse(res.bodyText);
                var locIso = res.result.addressComponent.country_code_iso;
                
                if(res.result.addressComponent.country !='China'){
                    _self.$dialog.confirm({
                        message: '根据定位,您所在的区域尚未开放服务,是否手动选择区域'
                    }).then(function(){
                        localStorage.setItem('position_loc',res.result.addressComponent.country);
                        _self.$router.push('location');
                    }).catch(function(){
                    });
                }else{
                    localStorage.setItem('position_loc',_self.Kit.getCountryMcc(locIso));
                    _self.$router.push('home');
                }
            },function(res){
                console.log(res);
            })
        }
         function showError(error) {
            localStorage.removeItem('position_loc');
            switch (error.code) {
                case error.PERMISSION_DENIED:
                        // 用于本地测试
                    _self.$dialog.alert({
                        message: '您已拒绝请求地理位置信息'
                    }).then(function(){
                        _self.$router.push('location');
                    });
                    break;
                case error.POSITION_UNAVAILABLE:
                    _self.$dialog.alert({
                        message: '位置信息不可用,请手动选择'
                    }).then(function(){
                        _self.$router.push('location');
                    });
                    break;
                case error.TIMEOUT:
                    _self.$dialog.alert({
                        message: '请求获取用户位置超时,请手动选择'
                    }).then(function(){
                        _self.$router.push('location');
                    });
                    break;
                case error.UNKNOWN_ERROR:
                    _self.$dialog.alert({
                        message: '定位系统失效,请手动选择'
                    }).then(function(){
                        _self.$router.push('location');
                    });
                    break;
            }
}
module.exports = {
	// 定位
         getLocation(){
            console.log(navigator)
            if (navigator.geolocation){
                navigator.geolocation.getCurrentPosition(showPosition,showError);
            }
            else{
                window.console("Geolocation is not supported by this browser.");
                _self.$dialog.alert({
                        message: '您的设备不支持定位功能,请手动选择'
                    }).then(function(){
                        _self.$router.push('location');
                    });
            }
        }
}