const http = ({
	url = '',
	params = {},
	...other
} = {}) => {
	let time = Date.now()
	return new Promise((resolve, reject) => {
		let token = uni.getStorageSync("token");
		uni.request({
			url: url,
			data: params,
			header: {
				'token': token,
				'content-type': 'application/json' // 默认值
			},
			...other,
			success: (res) => {
				if (res.data.code == 500 && res.data.msg == '用户不存在') {
					uni.showModal({
						content: '登录已过期 请重新登录',
						showCancel: false,
						success(res) {
							if (res.confirm) {
								uni.reLaunch({
									url: '/pages/login/login'
								})
							} else if (res.cancel) {
								uni.reLaunch({
									url: '/pages/login/login'
								})
							}
						}
					})
				}
				if (res.data.code == 402) {
					uni.reLaunch({
						url: '/pages/login/login'
					})
				}
				if (res.data.code == 401 || res.data.code == 403) {
					uni.showModal({
						content: '登录已过期 请重新登录',
						showCancel: false,
						success(res) {
							if (res.confirm) {
								uni.reLaunch({
									url: '/pages/login/login'
								})
							} else if (res.cancel) {
								uni.reLaunch({
									url: '/pages/login/login'
								})
							}
						}
					})
					resolve(res.data)
				}
				if (res.data.code == 200) {
					resolve(res.data)
				} else {
					resolve(res.data)
					//uni.showToast({ title: '无法请求接口', icon: 'none', duration: 2000 })
					reject(res)
				}
			},
			fail: (err) => {
				uni.hideLoading();
				console.log(err)
			}
		})
	})
}

module.exports = {
	get(url, params = {}) {
		return http({
			url,
			params
		})
	},
	post(url, params = {}) {
		return http({
			url,
			params,
			header: {
				"Content-Type": "application/json"
			},
			method: 'post'
		})
	},

	apost(url, params = {}) {
		return http({
			url,
			params,
			header: {
				"Content-Type": "application/json"
			},
			method: 'post'
		})
	},
	put(url, params = {}) {
		return http({
			url,
			params,
			method: 'put'
		})
	},
	// 这里不能使用 delete, delete为关键字段
	myDelete(url, params = {}) {
		return http({
			url,
			params,
			method: 'delete'
		})
	},

	/**
	 * 优惠券有效期
	 * startDate:起始日期
	 * valueTime：有效天数
	 */
	transferCouponValueTime(startDate, valueTime) {
		var date = new Date(startDate);
		var newDate = new Date(date.getFullYear(), date.getMonth(), date.getDate() + valueTime);
		var year1 = date.getFullYear();
		var month1 = date.getMonth() + 1;
		var day1 = date.getDate();
		var year2 = newDate.getFullYear();
		var month2 = newDate.getMonth() + 1;
		var day2 = newDate.getDate();
		return year2 + "/" + month2 + "/" + day2
	},

	//获取时间
	getDate(type) {
		const date = new Date();
		let year = date.getFullYear();
		let month = date.getMonth() + 1;
		let day = date.getDate();

		if (type === 'start') {
			year = year - 60;
		} else if (type === 'end') {
			year = year + 2;
		}
		month = month > 9 ? month : '0' + month;;
		day = day > 9 ? day : '0' + day;
		return `${year}-${month}-${day}`;
	},

	// 转换为'00:00:00'
	getDuration(my_time) {
		if (my_time <= 0) {
			return '0'
		} else {
			var days = my_time / 1000 / 60 / 60 / 24;
			var daysRound = Math.floor(days);
			var hours = my_time / 1000 / 60 / 60 - (24 * daysRound);
			var hoursRound = Math.floor(hours) < 10 ? '0' + Math.floor(hours) : Math.floor(hours);
			var minutes = my_time / 1000 / 60 - (24 * 60 * daysRound) - (60 * hoursRound);
			var minutesRound = Math.floor(minutes) < 10 ? '0' + Math.floor(minutes) : Math.floor(minutes);
			var seconds = my_time / 1000 - (24 * 60 * 60 * daysRound) - (60 * 60 * hoursRound) - (60 *
				minutesRound);
			var secondsRound = Math.floor(seconds) < 10 ? '0' + Math.floor(seconds) : Math.floor(seconds)
			// console.log('转换时间:', hoursRound + '时', minutesRound + '分', seconds + '秒');
			// this.remaincutdown = hoursRound + ':' + minutesRound + ':' + seconds
			var time = daysRound + '天' + hoursRound + ':' + minutesRound + ':' + secondsRound
			return time
		}

	},

	// 获取当前时间
	getpresenttime() {
		var date = new Date(),
			year = date.getFullYear(),
			month = date.getMonth() + 1,
			day = date.getDate(),
			hour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours(),
			minute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes(),
			second = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
		month >= 1 && month <= 9 ? (month = "0" + month) : "";
		day >= 0 && day <= 9 ? (day = "0" + day) : "";
		var timer = year + '/' + month + '/' + day + ' ' + hour + ':' + minute + ':' + second;
		return timer;
	},

	//获取当前往后十年list
	getyearlist() {
		var date = new Date()
		var year = date.getFullYear()
		let yearlist = []
		for (var i = 0; i < 10; i++) {
			let years = year + i
			yearlist.push(years)
		}
		return yearlist
	},
	// 获取前后年份
	getNearbyFiveears() {
		let year = new Date().getFullYear()
		let arr = []
		for (var i = 0; i < 5; i++) {
			let year1 = year - i + 1;
			let year2 = year + i;
			arr.push(year1)
			arr.push(year2)
		}
		arr.sort((a, b) => {
			return a - b
		})
		let yearArr = arr.map((item, index) => {
			let obj = {}
			obj.label = item
			obj.value = index + 1
			return obj
		})
		yearArr.unshift({
			label: '全部',
			value: 0
		})
		return yearArr
	},
	// 获取当前时间
	getYearmomthday() {
		var date = new Date(),
			year = date.getFullYear(),
			month = date.getMonth() + 1,
			day = date.getDate(),
			hour = date.getHours() < 10 ? "0" + date.getHours() : date.getHours(),
			minute = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes(),
			second = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
		month >= 1 && month <= 9 ? (month = "0" + month) : "";
		day >= 0 && day <= 9 ? (day = "0" + day) : "";
		var timer = year + '/' + month + '/' + day;
		return timer;
	},

	//自定义加法运算
	addNum(num1, num2) {
		var sq1, sq2, m;
		try {
			sq1 = num1.toString().split(".")[1].length;
		} catch (e) {
			sq1 = 0;
		}
		try {
			sq2 = num2.toString().split(".")[1].length;
		} catch (e) {
			sq2 = 0;
		}
		m = Math.pow(10, Math.max(sq1, sq2));
		return (num1 * m + num2 * m) / m;
	},
	accMul(arg1, arg2) {
		var m = 0,
			s1 = arg1.toString(),
			s2 = arg2.toString();
		try {
			m += s1.split(".")[1].length
		} catch (e) {}
		try {
			m += s2.split(".")[1].length
		} catch (e) {}
		return Number(s1.replace(".", "")) * Number(s2.replace(".", "")) / Math.pow(10, m)
	},
}
