package com.example.afrishop_v3.vo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 爬取数据后，返回页面的商品详情数据
 *
 * @author G
 */
public class ProductResponse {

    /**
     * 原始价格 有优惠的话还有优惠价
     */
    private List<OriginalPrice> originalPriceList;
    /**
     * 是否包促销价格 true 有促销价格，false\null没有促销价格
     */
    private boolean promotionFlag;
    /**
     * 促销价格
     */
    private List<ProductPromotion> promotionList;
    /**
     * 原价一口价，就是商品一开始展示的价格，比如多sku多价格的情况下展示 18.80-49.90
     */
    private String price;
    /**
     * 促销一口价
     */
    private String salePrice;
    /**
     * 是否包含库存信息 有些商品没有库存信息，可以当作是有货 true 有库存信息，false没有
     */
    private boolean stockFlag;
    /**
     * 库存
     */
    private DynStock dynStock;
    /**
     * 是否包含商品属性，有些商品没有属性
     */
    private boolean propFlag;
    /**
     * 商品属性 颜色：红色，蓝色；尺码：S,l,M
     */
    private Map<String, Set<ProductProp>> productPropSet;
    /**
     * 商品信息
     */
    private ItemInfo itemInfo;
    /**
     * 商品来源平台 PlatformEnum
     */
    private String platform;

    public List<OriginalPrice> getOriginalPriceList() {
        return originalPriceList;
    }

    public void setOriginalPriceList(List<OriginalPrice> originalPriceList) {
        this.originalPriceList = originalPriceList;
    }

    public boolean isPromotionFlag() {
        return promotionFlag;
    }

    public void setPromotionFlag(boolean promotionFlag) {
        this.promotionFlag = promotionFlag;
    }

    public List<ProductPromotion> getPromotionList() {
        return promotionList;
    }

    public void setPromotionList(List<ProductPromotion> promotionList) {
        this.promotionList = promotionList;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(String salePrice) {
        this.salePrice = salePrice;
    }

    public boolean isStockFlag() {
        return stockFlag;
    }

    public void setStockFlag(boolean stockFlag) {
        this.stockFlag = stockFlag;
    }

    public DynStock getDynStock() {
        return dynStock;
    }

    public void setDynStock(DynStock dynStock) {
        this.dynStock = dynStock;
    }

    public boolean isPropFlag() {
        return propFlag;
    }

    public void setPropFlag(boolean propFlag) {
        this.propFlag = propFlag;
    }

    public Map<String, Set<ProductProp>> getProductPropSet() {
        return productPropSet;
    }

    public void setProductPropSet(Map<String, Set<ProductProp>> productPropSet) {
        this.productPropSet = productPropSet;
    }

    public ItemInfo getItemInfo() {
        return itemInfo;
    }

    public void setItemInfo(ItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }
}
