package com.example.afrishop_v3.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import net.sf.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.*;
import java.net.ConnectException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.*;

/**
 * @author mds
 * @DateTime 2018年4月25日 下午2:17:16
 * @Comment https工具类
 */
public class HttpsUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpsUtil.class);

    public static void main(String[] args) {
//		System.out.println(findToken());
//		System.out.println(findHtmToken("071MN2yB0H3dJg2M3eAB0Gi7yB0MN2yT"));
        //System.out.println(findUserInfo("001cKtlS17xJN61n88kS1N7olS1cKtl-"));
    }

    /**
     * @return
     * @author wmt
     * @DateTime 2019年4月17日 上午9:50:04
     * @serverComment 请求微信code2Session接口获取openid等信息
     */
    public static JSONObject findCode2Session(String code, String appId, String appSecret) {
        String url = "https://api.weixin.qq.com/sns/jscode2session";
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("appid", appId);
        param.put("secret", appSecret);
        param.put("js_code", code);
        param.put("grant_type", "authorization_code");
        url = urlParams(url, param);
        JSONObject jsonData = httpsReq(url, "GET", "");
        return jsonData;
    }


    /**
     * @return
     * @author mds
     * @DateTime 2018年4月25日 下午4:03:47
     * @serverComment 获取基础支持token和ticket
     */
    public static JSONObject findToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token";
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("grant_type", "client_credential");
        param.put("appid", "wx495f97d037fd5f93");
        param.put("secret", "7133214b34c3ee0dd294b1444ba46091");
        url = urlParams(url, param);
        JSONObject token = httpsReq(url, "GET", "");
        if (token != null && !token.containsKey("errcode")) {
            param.clear();
            String accessToken = token.getString("access_token");
            url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
            param.put("type", "jsapi");
            param.put("access_token", accessToken);
            JSONObject ticket = httpsReq(urlParams(url, param), "GET", "");
            if (ticket != null && 0 == ticket.getIntValue("errcode")) {
                token.put("ticket", ticket.get("ticket"));
            }
        }
        return token;
    }

    /**
     * @param code
     * @return
     * @author mds
     * @DateTime 2018年4月25日 下午4:23:07
     * @serverComment 通过code换取网页授权access_token
     */
    public static JSONObject findHtmToken(String code, String appId, String appSecret) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token";
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("grant_type", "authorization_code");
        param.put("appid", appId);
        param.put("secret", appSecret);
        param.put("code", code);
        JSONObject token = httpsReq(urlParams(url, param), "GET", "");
        return token;
    }

    /**
     * @param code
     * @return
     * @author mds
     * @DateTime 2018年4月25日 下午4:47:09
     * @serverComment code 获取用户信息
     */
    public static JSONObject findUserInfo(String code, String appId, String appSecret) {
        //获取网页授权access_token
        JSONObject token = findHtmToken(code, appId, appSecret);
        System.out.println("获取网页授权=" + token);
        if (!token.containsKey("errcode")) {
            String url = "https://api.weixin.qq.com/sns/userinfo";
            Map<String, Object> param = new HashMap<String, Object>();
            param.put("access_token", token.get("access_token"));
            param.put("openid", token.get("openid"));
            param.put("lang", "zh_CN");
            JSONObject userInfo = httpsReq(urlParams(url, param), "GET", "");
            return userInfo;
        }
        return null;
    }


    /**
     * 发送Https请求并获取结果
     *
     * @param method
     * @param data
     * @return
     */
    public static JSONObject httpsReq(String reqUrl, String method, String data) {
        String result = (String) sendHttps(reqUrl, method, data, false);
        if (StringUtils.isNotBlank(result)) {
            return JSON.parseObject(result);
        }
        return null;
    }

    /**
     * 发送Https请求并获取结果
     * <p>
     * 】
     *
     * @param method
     * @param data
     * @param xml    返回是否xml
     * @return
     */
    public static Object sendHttps(String reqUrl, String method, String data, boolean xml) {
        StringBuffer result = new StringBuffer();
        Map<String, String> resMap = new HashMap<String, String>();
        try {
            // 创建SSLContext对象,并使用我们指定的信任管理器初始化
            TrustManager[] tm = {new X509TM()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());

            // 获取SSLSocketFactory对象
            SSLSocketFactory ssf = sslContext.getSocketFactory();

            // 创建HttpsURLConnection对象，并设置其SSLSocketFactory对象
            URL url = new URL(reqUrl);
            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setSSLSocketFactory(ssf);

            // 设置连接参数
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(method);// 设置请求方式
			/*conn.setConnectTimeout(20000); //连接主机的超时时间（单位：毫秒）
			conn.setReadTimeout(20000); //从主机读取数据的超时时间（单位：毫秒）
*/
            if (method.equals("GET")) {
                conn.connect();
            }
            if (StringUtils.isNotBlank(data)) {
                OutputStream os = conn.getOutputStream();
                os.write(data.getBytes("utf-8"));
                os.close();
            }
            //获取返回信息
            InputStream input = conn.getInputStream();
            if (xml) {
                resMap = XmlUtil.xmlToMap(input);
            } else {
                InputStreamReader inputSR = new InputStreamReader(input, "utf-8");
                BufferedReader bufRea = new BufferedReader(inputSR);
                String str = null;
                while ((str = bufRea.readLine()) != null) {
                    result.append(str);
                }
                // 清理
                inputSR.close();
                bufRea.close();
            }
            input.close();
            input = null;
            conn.disconnect();
        } catch (ConnectException e) {
            // TODO Auto-generated catch block
            //System.out.println("网络连接超时...");
            logger.error(e.getMessage(), e);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            logger.error(e.getMessage(), e);
        }
        if (xml) {
            return resMap;
        } else {
            return result.toString();
        }
    }

    /**
     * @param param
     * @return
     * @author mds
     * @DateTime 2018年4月25日 下午2:38:54
     * @serverComment Map 转 url 参数
     */
    public static String urlParams(String url, Map<String, Object> param) {
        if (param == null) {
            return "";
        }
        StringBuffer params = new StringBuffer();
        if (StringUtils.isNotBlank(url)) {
            params.append(url + "?");
        }
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            params.append(entry.getKey() + "=" + entry.getValue());
            params.append("&");
        }
        String result = params.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    /**
     * @param params
     * @return
     * @author mds
     * @DateTime 2018年5月2日 下午2:30:38
     * @serverComment Map 转 url 参数
     */
    @SuppressWarnings("rawtypes")
    public static String urlParams(String url, SortedMap<Object, Object> params) {
        //实际可以不排序
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank(url)) {
            sb.append(url + "?");
        }
        Set es = params.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();
            if (null != v && !"".equals(v)) {
                sb.append(k + "=" + v + "&");
            }
        }
        sb.deleteCharAt(sb.length() - 1);//删掉最后一个&
        return sb.toString();
    }

    /**
     * http://opendata.baidu.com/api.php?query=41.186.78.199&co=&resource_id=6006&oe=utf8
     *
     * @param ip
     * @return adress
     */
    public static String ipToAdress(String ip) throws IOException {
        String url = "http://opendata.baidu.com/api.php";
        Map<String, Object> params = new HashMap();
        params.put("query", ip);
        params.put("co", "");
        params.put("resource_id", "6006");
        params.put("oe", "utf8");
        String result = HttpClientUtil.createConnection(url, params, "utf-8");
        System.out.println("ip:" + ip);
        System.out.println("result:" + result);
        net.sf.json.JSONObject jsonObject = net.sf.json.JSONObject.fromObject(result);
        JSONArray data = jsonObject.getJSONArray("data");
        String location = "";
        for (int i = 0; i < data.size(); i++) {
            net.sf.json.JSONObject object = data.getJSONObject(i);
            location = object.getString("location");
        }
        if (StringUtils.isNotBlank(location)) {
            String[] s = location.split(" ");
            location = s[0];
        }
        return location;

    }

    /**
     * http://ip-api.com/json/49.65.247.32?lang=zh-CN
     */
    public static String useIpFindCountry(String ip) throws IOException {
        String url = "http://ip-api.com/json/" + ip;
        Map<String, Object> params = new HashMap();
        params.put("lang", "zh-CN");
        String result = HttpClientUtil.createConnection(url, params, "utf-8");
        JSONObject jsonObject = JSONObject.parseObject(result);
        String status = jsonObject.getString("status");
        if ("success".equals(status)) {

            String country = jsonObject.getString("country");
            String city = jsonObject.getString("city");
            if (!city.equals(country)) {
                country = country + "-" + city;
            }
            System.out.println("result:" + result);
            System.out.println("country:" + country);
            return country;
        }
        return null;
    }

    /**
     * http://ip-api.com/json/49.65.247.32
     */
    public static String useIpFindCountryEn(String ip) throws IOException {
        String url = "http://ip-api.com/json/" + ip;
        Map<String, Object> params = new HashMap();
        String result = HttpClientUtil.createConnection(url, params, "utf-8");
        JSONObject jsonObject = JSONObject.parseObject(result);
        String status = jsonObject.getString("status");
        if ("success".equals(status)) {
            String country = jsonObject.getString("country");
            System.out.println("country:" + country);
            return country;
        }
        return null;
    }
}
