package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfCartRecordR;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface TbCfCartRecordRRepository extends PagingAndSortingRepository<TbCfCartRecordR, String> {
    int countByUserIdAndEnableFlag(String userId,Integer flag);

    Optional<TbCfCartRecordR> findFirstByUserIdAndItemIdAndItemSkuAndEnableFlag(String userId, String itemId, String itemSku, Integer flag);

    Optional<TbCfCartRecordR> findFirstByUserIdAndItemImgAndItemSkuAndEnableFlag(String userId, String itemImg, String itemSku, Integer flag);

    Optional<TbCfCartRecordR> findFirstByUserIdAndSourceItemIdAndItemSkuAndEnableFlag(String userId, String sourceItemId, String itemSku, Integer flag);

    @Query(value = "select a from #{#entityName} a left join TbCfStationItem x on a.itemId=x.itemId WHERE  a.userId=:userId and (x.enableFlag = 1 or x.enableFlag IS NULL)  and a.enableFlag=1 order by a.createTime desc")
    List<TbCfCartRecordR> findAllByUserIdOrderByCreateTimeDesc(@Param("userId") String userId,Pageable pageable);

    List<TbCfCartRecordR> findAllByCartRecordIdIn(String[] ids);


    @Modifying
    @Transactional
    @Query(value = "update tb_cf_cart_record_r set enable_flag=0 where cart_record_id in :ids", nativeQuery = true)
    void updateCartCheckFlag(@Param("ids") String[] ids);

    @Modifying
    @Transactional
    void deleteAllByCartRecordIdIn(String[] ids);

    @Modifying
    @Query(value = "update tb_cf_item_skus sk INNER JOIN tb_cf_cart_record_r r ON r.item_sku_id=sk.id set sk.sku_count=sk.sku_count-r.item_num WHERE r.cart_record_id IN :ids ", nativeQuery = true)
    void updateSkuQuantity(@Param("ids") String[] ids);

    @Modifying
    @Query(value = "update tb_cf_station_item sk INNER JOIN tb_cf_cart_record_r r ON r.item_id=sk.item_id set sk.item_count=sk.item_count-r.item_num WHERE r.cart_record_id IN :ids ", nativeQuery = true)
    void updateItemQuantity(@Param("ids") String[] ids);

    @Modifying
    @Query(value = "update tb_cf_station_item sk INNER JOIN tb_cf_cart_record_r r ON r.item_id=sk.item_id set sk.enable_flag=0 WHERE sk.item_count-r.item_num<=0 and r.cart_record_id IN :ids ", nativeQuery = true)
    void updateItemsShelf(@Param("ids") String[] ids);


    @Modifying
    @Query(value = "update tb_cf_item_skus sk set sk.sku_count=sk.sku_count-:val WHERE sk.id = :id ", nativeQuery = true)
    void updateSkuQuantity_(@Param("id") String id, @Param("val") int count);

    @Modifying
    @Query(value = "update tb_cf_station_item sk set sk.item_count=sk.item_count-:val WHERE sk.item_id = :id ", nativeQuery = true)
    void updateItemQuantity_(@Param("id") String id, @Param("val") int count);

    @Modifying
    @Query(value = "update tb_cf_station_item sk set sk.enable_flag=0 WHERE sk.item_id = :id and sk.item_count-:val<=0 ", nativeQuery = true)
    void updateItemShelf_(@Param("id") String id, @Param("val") int count);
}
