package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Country;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @Auther: wudepeng
 * @Date: 2021/01/14
 * @Description:
 */
public interface CountryRepository extends JpaRepository<Country, String> {

    //    @Query(value = "select c from #{#entityName} c where c.countryName=:country order by c.sort,c.countryName")
    @Query(value = "select c.id,c.country_name,c.country_cname,c.area_code,c.national_flag from country c where if(?1!='',c.country_name like ?1% or c.country_cname like ?1%,1=1) order by isnull(c.sort), c.sort asc ,c.country_name asc", nativeQuery = true)
    List<Country> findAllByCountryName(String country);
}
