package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.CommentLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface CommentLikeRepository extends PagingAndSortingRepository<CommentLike,String> {
    Page<CommentLike> findAllByCommentId(String comment_id, Pageable pageable);


    @Query(value = "delete from comment_like WHERE comment_id=:comment",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByComment_Id(@Param("comment") String comment_id);
}
