package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 用户表实体
 * 表名 tb_cf_user_info
 *
 * @author lipengjun
 * @date 2020-02-20 12:04:18
 */
@ToString
@Entity
@Getter
@Setter
public class TbCfUserInfo {

    /**
     * 用户id
     */
    @Id
    @Column(length = 64)
    private String userId;
    /**
     * 用户编号
     */
    private String userNo;
    /**
     * 用户类型（1邮箱、2facebook、3twitter、4手机）
     */
    private Integer userType;
    /**
     * 账号
     */
    private String account;
    /**
     * 用户头像地址
     */
    private String avatar;
    /**
     * 用户名
     */
    private String nick;
    /**
     * 电话号码
     */
    private String phone;
    /**
     * 是否绑定手机
     */
    private Integer phoneFlag;
    /**
     * 密码
     */
    private String password;
    /**
     * 上一次登录时间
     */
    private Date lastLoginTime;
    /**
     * 上一次登录IP
     */
    private String lastLoginIp;
    /**
     * 登录次数
     */
    private Integer loginCount;
    /**
     * 邮箱
     */
    private String email;
    /**
     * facebook账号
     */
    private String facebook;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 性别,0未知，1男性，2女性
     */
    private Integer sex;
    /**
     * 生日
     */
    private Date birthday;
    /**
     * 默认地址id
     */
    @ManyToOne
    @JsonIgnore
    @JoinColumn(columnDefinition = "default_address_id", name = "default_address_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private TbCfAddress address;
    /**
     * 发出邀请的用户
     */
    private String invitedUserId;
    /**
     * 总共邀请数量
     */
    private Integer invitedCount;
    /**
     * 是否有效
     */
    private Integer enableFlag;
    /**
     * 邮箱是否已经验证
     */
    private Integer emailFlag;
    /**
     * 0未发送，1已发送
     */
    private Integer isSend;

    @Transient
    private String token;

    @Column(unique = true)
    private String firebaseUid;

    @JsonIgnore
    private String verificationCode;

    @JsonIgnore
    private Date codeSentTime;

    @JsonIgnore
    private Integer sentCount = 0;


    private String slogan;

    private String fcm;

    @Column(unique = true)
    private String code;

    private Integer source;

    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(unique = true)
    private Long codeCount;

    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM following c WHERE c.followed_info_user_id=user_id)")
    private int followers;//Count users following

    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM post_data c WHERE c.id IN (SELECT l.post_id FROM post_like_v2 l WHERE l.user_info_user_id=user_id))")
    private int likes;//Counts user's liked posts
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM following c WHERE c.follower_info_user_id=user_id)")
    private int following;//Count users followers
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM post_data c WHERE c.user_info_user_id=user_id)")
    private int posts;//Count users posts
    @Formula(value = "(SELECT IFNULL(SUM(c.amount),0.0) FROM bonus c WHERE c.user_info_user_id=user_id and c.is_withdraw=false)")
    private double bonus;//Sum up all collected bonuses
    @Formula(value = "(SELECT IFNULL(SUM(c.amount),0.0) FROM bonus c WHERE c.user_info_user_id=user_id and c.is_withdraw=true)")
    private double withdraw;//sum withdrawn amount on his account
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM visit c  INNER JOIN post_data p ON p.id=c.post_id WHERE p.user_info_user_id=user_id)")
    private int visits;//Count user's visits
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM network c WHERE c.user_info_user_id=user_id)")
    private int networks; //count users networks
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM network c WHERE c.network_info_user_id=user_id)")
    private int invitation;// count users invitations

    @Transient
    @JsonProperty
    public BigDecimal networkAmount;

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    private String country;

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setCodeSentTime(Date codeSentTime) {
        this.codeSentTime = codeSentTime;
    }

    public Date getCodeSentTime() {
        return codeSentTime;
    }

    public String getCode() {
        return code;
    }

    @JsonProperty
    public boolean invited() {
        return invitation > 0;
    }

    public Integer getSentCount() {
        return sentCount;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getCodeCount() {
        return codeCount;
    }

    public String getVerificationCode() {
        return verificationCode;
    }

    public void setSentCount(Integer sentCount) {
        this.sentCount = sentCount;
    }

    public String getToken() {
        return token;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    @JsonIgnore
    public Map<String, Object> smallMap() {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("username", display());
        map.put("userId", getUserId());
        map.put("avatar", getAvatar());
        map.put("code", getCode());
        map.put("phone", getPhone());
        map.put("email", getEmail());
        map.put("bio", getSlogan());
        map.put("lastLoginTime", getLastLoginTime());
        return map;
    }


    public void setFcm(String fcm) {
        this.fcm = fcm;
    }

    public boolean hasFcm() {
        return !StringUtils.isBlank(fcm);
    }

    public String getFcm() {
        return fcm;
    }

    public String getSlogan() {
        return slogan;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getFirebaseUid() {
        return firebaseUid;
    }

    public void setFirebaseUid(String firebaseUid) {
        this.firebaseUid = firebaseUid;
    }

    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }

    public void setInvitation(int inv) {
        this.invitation = inv;
    }


    @JsonProperty
    public BigDecimal getWallet() {
        return BigDecimal.valueOf(ogWallet()).setScale(3, RoundingMode.HALF_UP);
    }

    public double ogWallet() {
        return bonus + withdraw;
    }

    /**
     * 设置：用户编号
     */
    public void setUserNo(String userNo) {
        this.userNo = userNo;
    }

    /**
     * 获取：用户编号
     */
    public String getUserNo() {
        return userNo;
    }

    /**
     * 设置：用户类型（1邮箱、2facebook、3twitter、4手机）
     */
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    /**
     * 获取：用户类型（1邮箱、2facebook、3twitter、4手机）
     */
    public Integer getUserType() {
        return userType;
    }

    /**
     * 设置：账号
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * 获取：账号
     */
    public String getAccount() {
        return account;
    }

    /**
     * 设置：用户头像地址
     */
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    /**
     * 获取：用户头像地址
     */
    public String getAvatar() {
        return avatar;
    }

    /**
     * 设置：用户名
     */
    public void setNick(String nick) {
        this.nick = nick;
    }

    /**
     * 获取：用户名
     */
    public String getNick() {
        return nick;
    }

    public String display() {
        return getNick() != null && !getNick().isEmpty() ? getNick() : getEmail() != null && !getEmail().isEmpty() ? getEmail() : getPhone();
    }

    /**
     * 设置：电话号码
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 获取：电话号码
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 设置：是否绑定手机
     */
    public void setPhoneFlag(Integer phoneFlag) {
        this.phoneFlag = phoneFlag;
    }

    /**
     * 获取：是否绑定手机
     */
    public Integer getPhoneFlag() {
        return phoneFlag;
    }

    /**
     * 设置：密码
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * 获取：密码
     */
    public String getPassword() {
        return password;
    }

    /**
     * 设置：上一次登录时间
     */
    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    /**
     * 获取：上一次登录时间
     */
    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    /**
     * 设置：上一次登录IP
     */
    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    /**
     * 获取：上一次登录IP
     */
    public String getLastLoginIp() {
        return lastLoginIp;
    }

    /**
     * 设置：登录次数
     */
    public void setLoginCount(Integer loginCount) {
        this.loginCount = loginCount;
    }

    /**
     * 获取：登录次数
     */
    public Integer getLoginCount() {
        return loginCount;
    }

    /**
     * 设置：邮箱
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 获取：邮箱
     */
    public String getEmail() {
        return email;
    }

    /**
     * 设置：facebook账号
     */
    public void setFacebook(String facebook) {
        this.facebook = facebook;
    }

    /**
     * 获取：facebook账号
     */
    public String getFacebook() {
        return facebook;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置：性别,0未知，1男性，2女性
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 获取：性别,0未知，1男性，2女性
     */
    public Integer getSex() {
        return sex;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    /**
     * 设置：默认地址id
     */

    public void setAddress(TbCfAddress address) {
        this.address = address;
    }

    public TbCfAddress getAddress() {
        return address;
    }

    /**
     * 获取：默认地址id
     */

    /**
     * 设置：发出邀请的用户
     */
    public void setInvitedUserId(String invitedUserId) {
        this.invitedUserId = invitedUserId;
    }

    /**
     * 获取：发出邀请的用户
     */
    public String getInvitedUserId() {
        return invitedUserId;
    }

    /**
     * 设置：总共邀请数量
     */
    public void setInvitedCount(Integer invitedCount) {
        this.invitedCount = invitedCount;
    }

    /**
     * 获取：总共邀请数量
     */
    public Integer getInvitedCount() {
        return invitedCount;
    }

    /**
     * 设置：是否有效
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否有效
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    /**
     * 设置：邮箱是否已经验证
     */
    public void setEmailFlag(Integer emailFlag) {
        this.emailFlag = emailFlag;
    }

    /**
     * 获取：邮箱是否已经验证
     */
    public Integer getEmailFlag() {
        return emailFlag;
    }

    /**
     * 设置：0未发送，1已发送
     */
    public void setIsSend(Integer isSend) {
        this.isSend = isSend;
    }

    /**
     * 获取：0未发送，1已发送
     */
    public Integer getIsSend() {
        return isSend;
    }

    @JsonIgnore
    public Collection<String> getRoles() {
        ArrayList<String> objects = new ArrayList<>();
        objects.add("user");
        return objects;
    }
}
