package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Where;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Nullable;
import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 实体
 * 表名 tb_cf_item_comment
 *
 * @author lipengjun
 * @date 2020-01-09 10:17:03
 */
@Entity
@Data
@Where(clause = "del_flag=1")
public class TbCfItemComment {

    /**
     * 商品评论ID
     */
    @Id
    private String id;
    /**
     * 评论人
     */
    @ManyToOne
    @JsonIgnore
    @JoinColumn(columnDefinition = "user_id", name = "user_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private TbCfUserInfo user;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 商品ID
     */
    private String itemId;
    /**
     * 类型 0： 只有文本内容 1：带图片
     */
    private Integer type;
    /**
     * 图片或视频的url
     */
    private String urls;
    /**
     * 商品评分
     */
    private Integer itemScore;
    /**
     * 服务评分
     */
    private Integer serviceScore;
    /**
     * 物流评分
     */
    private Integer logisticsScore;
    /**
     * 价格评分
     */
    private Integer priceScore;
    /**
     * 商品评论
     */
    private String itemReview;
    /**
     * 点赞人数
     */
    private Long likeNum;
    /**
     * 删除标志 0：正常 1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;

    @JsonIgnore
//    @Transient
    private Integer commentType;
    /**
     * 更新时间
     */
    private Date updateTime;

    @Transient
    private String userName;

    @Transient
    private String avatar;

//    private String orderNo;
//    private String itemName;

    @Transient
    private boolean isLike;

//    @JsonIgnore
//    @Transient
//    private MultipartFile[] files;

    @Formula(value = "(SELECT IFNULL(COUNT(*),0) FROM tb_cf_item_like lk where lk.comment_id = id)")
    private int likeCount;
    @Transient
    private double score;
    @Transient
    private double totalScore;


    private String attributs;

    public String getAttributs() {
        return attributs;
    }

    public void setAttributs(String attributs) {
        this.attributs = attributs;
    }

    public double getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(double totalScore) {
        this.totalScore = totalScore;
    }

    public double getScore() {
        score = (double) (getItemScore() + getServiceScore() + getLogisticsScore() + getPriceScore()) / 4;
        return Double.parseDouble(String.format("%.1f", score));
    }

    public void setScore(double score) {
        this.score = score;
    }

    public boolean isLike() {
        return isLike;
    }

    public void setLike(boolean like) {
        isLike = like;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

//    public String getOrderNo() {
//        return orderNo;
//    }
//
//    public void setOrderNo(String orderNo) {
//        this.orderNo = orderNo;
//    }
//
//    public String getItemName() {
//        return itemName;
//    }
//
//    public void setItemName(String itemName) {
//        this.itemName = itemName;
//    }

    /**
     * 设置：商品评论ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：商品评论ID
     */
    public String getId() {
        return id;
    }

    /**
     * 设置：评论人
     */
    public void setUser(TbCfUserInfo user) {
        this.user = user;
    }


    @PostLoad
    public void catchName() {
        this.userName = user == null ? "" : user.display();
        this.avatar = user == null ? "" : user.getAvatar();
    }

    public String getUserId() {
        return user != null ? user.getUserId() : null;
    }

    /**
     * 设置：订单ID
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取：订单ID
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * 设置：商品ID
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品ID
     */
    public String getItemId() {
        return itemId;
    }

    /**
     * 设置：类型 0： 只有文本内容 1：带图片
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 获取：类型 0： 只有文本内容 1：带图片
     */
    public Integer getType() {
        return type;
    }

    /**
     * 设置：图片或视频的url
     */
    public void setUrls(String urls) {
        this.urls = urls;
    }

    /**
     * 获取：图片或视频的url
     */
    public String getUrls() {
        return urls;
    }

    public String[] getImgs() {
        return urls != null ? urls.split(";") : null;
    }

    public Integer getImgLength() {
        return urls != null ? urls.split(";").length : 0;
    }

    /**
     * 设置：商品评分
     */
    public void setItemScore(Integer itemScore) {
        this.itemScore = itemScore;
    }

    /**
     * 获取：商品评分
     */
    public Integer getItemScore() {
        return itemScore;
    }

    /**
     * 设置：服务评分
     */
    public void setServiceScore(Integer serviceScore) {
        this.serviceScore = serviceScore;
    }

    /**
     * 获取：服务评分
     */
    public Integer getServiceScore() {
        return serviceScore;
    }

    /**
     * 设置：物流评分
     */
    public void setLogisticsScore(Integer logisticsScore) {
        this.logisticsScore = logisticsScore;
    }

    /**
     * 获取：物流评分
     */
    public Integer getLogisticsScore() {
        return logisticsScore;
    }

    /**
     * 设置：价格评分
     */
    public void setPriceScore(Integer priceScore) {
        this.priceScore = priceScore;
    }

    /**
     * 获取：价格评分
     */
    public Integer getPriceScore() {
        return priceScore;
    }

    /**
     * 设置：商品评论
     */
    public void setItemReview(String itemReview) {
        this.itemReview = itemReview;
    }

    /**
     * 获取：商品评论
     */
    public String getItemReview() {
        return itemReview;
    }

    /**
     * 设置：点赞人数
     */
    public void setLikeNum(Long likeNum) {
        this.likeNum = likeNum;
    }

    /**
     * 获取：点赞人数
     */
    public Long getLikeNum() {
        return likeNum;
    }

    /**
     * 设置：删除标志 0：正常 1：已删除
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标志 0：正常 1：已删除
     */
    public Integer getDelFlag() {
        return delFlag;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    public TbCfUserInfo getUser() {
        return user;
    }

    public Integer getCommentType() {
        return commentType;
    }

    public void setCommentType(Integer commentType) {
        this.commentType = commentType;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public int getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(int likeCount) {
        this.likeCount = likeCount;
    }
}
