package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 运费模板实体
 * 表名 tb_cf_express_template
 *
 * @author lipengjun
 * @date 2020-08-27 14:58:56
 */
@Entity
@Data
public class TbCfExpressTemplate{

    /**
     * 模板id
     */
    @Id
    private String templateId;
    /**
     * 模板标题
     */
    private String templateTitle;
    /**
     * 计费方式 0：计件 1：计重
     */
    private Integer type;
    /**
     * 商品类型
     */
    private String itemCategoryId;
    /**
     * 起始数量
     */
    private Integer startNum;
    /**
     * 快递费
     */
    private BigDecimal expressFee;
    /**
     * 续件数量
     */
    private Integer continuationNum;
    /**
     * 续件费用
     */
    private BigDecimal continuationFee;
    /**
     * 手续费
     */
    private BigDecimal handlingFee;
    /**
     * 关税
     */
    private BigDecimal tariff;
    /**
     * 国家编号
     */
    private String countryCode;
    /**
     * 国家
     */
    private String country;
    /**
     * 状态 0：删除 1：正常
     */
    private Integer status;
    /**
     * 地区默认模板 0：默认 1：非默认
     */
    private Integer isDefault;
    /**
     * 免邮价格
     */
    private BigDecimal postageFreePrice;
    /**
     * 创建日期
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：模板id
     */
    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    /**
     * 获取：模板id
     */
    public String getTemplateId() {
        return templateId;
    }
    /**
     * 设置：模板标题
     */
    public void setTemplateTitle(String templateTitle) {
        this.templateTitle = templateTitle;
    }

    /**
     * 获取：模板标题
     */
    public String getTemplateTitle() {
        return templateTitle;
    }
    /**
     * 设置：计费方式 0：计件 1：计重
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 获取：计费方式 0：计件 1：计重
     */
    public Integer getType() {
        return type;
    }
    /**
     * 设置：商品类型
     */
    public void setItemCategoryId(String itemCategoryId) {
        this.itemCategoryId = itemCategoryId;
    }

    /**
     * 获取：商品类型
     */
    public String getItemCategoryId() {
        return itemCategoryId;
    }
    /**
     * 设置：起始数量
     */
    public void setStartNum(Integer startNum) {
        this.startNum = startNum;
    }

    /**
     * 获取：起始数量
     */
    public Integer getStartNum() {
        return startNum;
    }
    /**
     * 设置：快递费
     */
    public void setExpressFee(BigDecimal expressFee) {
        this.expressFee = expressFee;
    }

    /**
     * 获取：快递费
     */
    public BigDecimal getExpressFee() {
        return expressFee;
    }
    /**
     * 设置：续件数量
     */
    public void setContinuationNum(Integer continuationNum) {
        this.continuationNum = continuationNum;
    }

    /**
     * 获取：续件数量
     */
    public Integer getContinuationNum() {
        return continuationNum;
    }
    /**
     * 设置：续件费用
     */
    public void setContinuationFee(BigDecimal continuationFee) {
        this.continuationFee = continuationFee;
    }

    /**
     * 获取：续件费用
     */
    public BigDecimal getContinuationFee() {
        return continuationFee;
    }
    /**
     * 设置：手续费
     */
    public void setHandlingFee(BigDecimal handlingFee) {
        this.handlingFee = handlingFee;
    }

    /**
     * 获取：手续费
     */
    public BigDecimal getHandlingFee() {
        return handlingFee;
    }
    /**
     * 设置：关税
     */
    public void setTariff(BigDecimal tariff) {
        this.tariff = tariff;
    }

    /**
     * 获取：关税
     */
    public BigDecimal getTariff() {
        return tariff;
    }
    /**
     * 设置：国家编号
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * 获取：国家编号
     */
    public String getCountryCode() {
        return countryCode;
    }
    /**
     * 设置：国家
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * 获取：国家
     */
    public String getCountry() {
        return country;
    }
    /**
     * 设置：状态 0：删除 1：正常
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取：状态 0：删除 1：正常
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置：地区默认模板 0：默认 1：非默认
     */
    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    /**
     * 获取：地区默认模板 0：默认 1：非默认
     */
    public Integer getIsDefault() {
        return isDefault;
    }
    /**
     * 设置：免邮价格
     */
    public void setPostageFreePrice(BigDecimal postageFreePrice) {
        this.postageFreePrice = postageFreePrice;
    }

    /**
     * 获取：免邮价格
     */
    public BigDecimal getPostageFreePrice() {
        return postageFreePrice;
    }
    /**
     * 设置：创建日期
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建日期
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
