package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.Bonus;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.BonusRepository;
import com.example.afrishop_v3.repository.UserRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/discover/withdraw")
public class WithdrawController {
    private final BonusRepository repository;
    private final UserRepository userRepository;

    public WithdrawController(BonusRepository repository, UserRepository userRepository) {
        this.repository = repository;
        this.userRepository = userRepository;
    }

    @GetMapping(value = "/withdrawsByUserId/{userId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Bonus> getList(@PathVariable(value = "userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByUserInfo_UserIdAndWithdraw(id,true, PageRequest.of(pageNo, pageSize)).toList();
    }

    @PostMapping(value = "/saveWithdraw")
    public Result saveWithdraw(@ModelAttribute("Bonus") Bonus withdraw) {

        int code = 1;
        String message = "Withdraw request received";
        if( withdraw.getUserId() == null ){
            message = "Service Error";
            code = 0;
        }

        Optional<TbCfUserInfo> byId = withdraw.getUserId() == null ? Optional.empty() : userRepository.findById(withdraw.getUserId());
        //Check Id availability
        if( !byId.isPresent() ){
            code = 0;
            message = "Service Error";
        }
        //Check balance
        if( byId.isPresent() && byId.get().ogWallet() < withdraw.getAmount().doubleValue() ){
           code = 0;
           message = "Insufficient balance";
        }

        if( code == 1 ){
            withdraw.reverseAmount();
            withdraw = repository.save(withdraw);
        }

         return  new Result<>(withdraw,code,message);
    }
}
