package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfProblem;
import com.example.afrishop_v3.repository.TbCfProblemRepository;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.net.URLDecoder;

@RestController
@RequestMapping("/problem")
public class ProblemController {
    private final TbCfProblemRepository repository;

    public ProblemController(TbCfProblemRepository repository) {
        this.repository = repository;
    }

    // type 0:Problem 1:ShippingClause
    @GetMapping
    public Result getProblemList(@RequestParam(required = false) Integer pageNum,
                                 @RequestParam(required = false) Integer pageSize) {
        //Assign defaults if no parameters sent
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 10 : pageSize;
        return new Result<>(repository.findAll(PageRequest.of(pageNum, pageSize)));

    }

    @GetMapping("/{type}")
    public Result getShippingClause(@PathVariable Integer type) throws Exception {
        TbCfProblem clause = repository.findFirstByTypeOrderByCreateTimeDesc(type);
        String shippingClause = URLDecoder.decode(clause.getAnswer(), "utf-8");
        TbCfProblem problem = new TbCfProblem();
        problem.setQuestion(clause.getQuestion());
        problem.setAnswer(shippingClause);
        return new Result<>(problem);
    }

}
