package com.example.afrishop_v3.bis.impl;

import com.example.afrishop_v3.bis.IItemSpider;
import com.example.afrishop_v3.enums.PlatformEnum;
import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.TranslateHelper;
import com.example.afrishop_v3.vo.*;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.example.afrishop_v3.util.SpiderUtil.exchangeRate;


/**
 * H&M 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("hmSpider")
public class HmSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(UniqloSpider.class);

    /**
     * H&M 数据格式化
     *
     * @param targetUrl
     * @return
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(targetUrl);
        matcher.find();
        targetUrl = "https://www.hm.com.cn/en_cn/" + matcher.group() + ".html";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.HM.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * TODO 存在把不在页面上显示的颜色的尺码也算了进去
     *
     * @param content 页面数据
     * @return 格式化后的数据
     */
    public static ProductResponse formatProductResponse(String content) throws IOException, URISyntaxException {
        Document document = Jsoup.parse(content);
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(false);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("H&M");
        itemInfo.setShopUrl("https://www.hm.com.cn/");
        itemInfo.setItemId(document.select("div[class=product-info-main]").select("a").attr("data-product-id"));
        itemInfo.setTitle(document.select("meta[name=title]").attr("content"));
        //////////////////////////////////// 获取商品基本信息(图片下取)End /////////////////////////

        // 获取原始价
        String fullPrice = document.select("meta[property=product:price:amount]").attr("content");
        // TODO 转换汇率，目前商品单位是人民币
        fullPrice = exchangeRate(fullPrice);

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
        // 取页面的数据
        Elements colorEle = document.select("div[id=article-list-owl]").select("div");
        List<String> urlList = new ArrayList<>();
        for (Element element : colorEle) {
            if (!StringUtils.isEmpty(element.attr("data-product-url"))) {
                // 获取其他商品的链接
                urlList.add(element.attr("data-product-url"));
            }
        }

        for (String url : urlList) {

            content = HttpClientUtil.getContentByUrl(url, PlatformEnum.HM.getValue());
            document = Jsoup.parse(content);

            colorEle = document.select("span[class=current-article-title]");

            String color = colorEle.attr("data-title");
            String imgUrl = document.select("meta[property=og:image]").attr("content");

            itemInfo.setPic(imgUrl);

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(color);
            productPropColor.setPropName(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            ///////////////////////// 获取商品尺码属性 ///////////////////////////////////////////////////////////
            Elements sizeEles = document.select("div[class=picker-content]").select("div[class=size-option ]").select("span[class=variant-size-value]");
            for (Element sizeEle : sizeEles) {

                String size = sizeEle.text();
                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(size);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性END //////////////////////////////////////////////////////

                // 设置 skuStr
                String skuStr = ";" + color + ";" + size + ";";
                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("H&M");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
