package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonBackReference;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 商品属性实体
 * 表名 tb_cf_option
 *
 * @author lipengjun
 * @date 2019-12-26 16:36:21
 */
@Entity
@Getter
@Setter
public class TbCfOption{

    /**
     * 商品属性
     */
    @Id
    private String optionId;
    /**
     * 属性名
     */
    private String optionName;
    /**
     * 属性种类
     */
    private String optiionSpecies;
    /**
     * 商品ID
     */
    private String itemId;
    /**
     * 商品规格ID
     */
    @ManyToOne
    @JsonBackReference
    @JoinColumn(columnDefinition = "cid",name = "cid")
    private TbCfCategory category;
    /**
     * 删除标志 0：正常 1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：商品属性
     */
    public void setOptionId(String optionId) {
        this.optionId = optionId;
    }

    /**
     * 获取：商品属性
     */
    public String getOptionId() {
        return optionId;
    }

    /**
     * 设置：属性名
     */
    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    /**
     * 获取：属性名
     */
    public String getOptionName() {
        return optionName;
    }

    /**
     * 设置：属性种类
     */
    public void setOptiionSpecies(String optiionSpecies) {
        optiionSpecies = optiionSpecies.trim();
        this.optiionSpecies = optiionSpecies;
    }

    /**
     * 获取：属性种类
     */
    public String getOptiionSpecies() {
        return optiionSpecies != null ? optiionSpecies.trim() : null;
    }

    /**
     * 设置：商品ID
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品ID
     */
    public String getItemId() {
        return itemId;
    }


    /**
     * 设置：删除标志 0：正常 1：已删除
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标志 0：正常 1：已删除
     */
    public Integer getDelFlag() {
        return delFlag;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
