package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.Hashtag;
import com.example.afrishop_v3.repository.HashtagRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class HashtagController {
    private final HashtagRepository repository;

    public HashtagController(HashtagRepository repository) {
        this.repository = repository;
    }

    //Get paginated list of hashtags
    @GetMapping(value = "/home/listHashtags")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Hashtag> getList(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAll(PageRequest.of(pageNo, pageSize, Sort.by(Sort.Order.desc("count")))).toList();
    }

    //Search hash tags
    @GetMapping(value = "/searchHashtags/{query}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Hashtag> getSearch(@PathVariable(value = "query") String query, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByNameContaining(query, PageRequest.of(pageNo, pageSize,Sort.by(Sort.Order.desc("count")))).toList();
    }


    //Create new hash tag
    @PostMapping(value = "/saveHashTag")
    public Hashtag saveProduct(@ModelAttribute("Hashtag") Hashtag hashtag) {
        if( repository.existsByName(hashtag.getName()))
            return hashtag;
        return repository.save(hashtag);
    }
}
