package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.IdUtil;
import com.google.api.gax.paging.Page;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.collect.Lists;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.messaging.*;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class Controller {

    public static final String LOCAL_IP = "127.0.0.1";//本地ip地址
    public static final String DEFAULT_IP = "0:0:0:0:0:0:0:1";//默认ip地址
    public static final int DEFAULT_IP_LENGTH = 15;//默认ip地址长度

    String uid() {
        return IdUtil.createIdbyUUID();
    }


    static boolean isEmailValid(String email) {
        return validRex(email,"^[\\w.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$");
    }

    static boolean isPhoneValid(String phone) {
        return validRex(phone,"^(?:[+0]9)?[0-9]{8,14}$");
    }

    static boolean isPasswordVeryStrong(String password) {
        return validRex(password,"^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%^&+=])(?=\\S+$).{8,}$");
    }

    static boolean isPasswordValid(String password) {
        return validRex(password,"^(?=.*[0-9])(?=.*[A-Z]).{8,}$");
    }

    static boolean isPasswordValidDigit(String password) {
        return validRex(password,"^(?=.*[0-9])$");
    }

    static boolean isPasswordValidUpperCase(String password) {
        return validRex(password,"^(?=.*[A-Z])$");
    }

    static boolean isPasswordValidLength(String password) {
        return validRex(password,"^.{8,}$");
    }

    private static boolean validRex(String text,String expression){

        Pattern pattern = Pattern.compile(expression, Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    static int id = 0;
    NumberFormat formatter = new DecimalFormat("#0.00");

     void authExplicit() throws IOException {
        // You can specify a credential file by providing a path to GoogleCredentials.
        // Otherwise credentials are read from the GOOGLE_APPLICATION_CREDENTIALS environment variable.
        InputStream in = new ClassPathResource("afrishop-6e142-a74ff3091e0c.json").getInputStream();
        GoogleCredentials credentials = GoogleCredentials.fromStream(in)
                .createScoped(Lists.newArrayList("https://www.googleapis.com/auth/cloud-platform"));
        Storage storage = StorageOptions.newBuilder().setCredentials(credentials).build().getService();


        System.out.println("Buckets:");
        Page<Bucket> buckets = storage.list();
        for (Bucket bucket : buckets.iterateAll()) {
            System.out.println(bucket.toString());
        }
    }

    private FirebaseApp getApp() {
        FirebaseOptions options;
        try {
            InputStream in = new ClassPathResource("afrishop-6e142-firebase-adminsdk-ypj91-b5e0248586.json").getInputStream();
            // InputStream in = ResourceUtils.getURL("src/main/resources/afrishop-6e142-firebase-adminsdk-ypj91-b5e0248586.json").openStream();
            options = new FirebaseOptions.Builder()
                    .setCredentials(GoogleCredentials.fromStream(in))
                    .setDatabaseUrl("https://afrishop-6e142.firebaseio.com")
                    .build();
            FirebaseApp firebaseApp;
            try {
                firebaseApp = FirebaseApp.getInstance("other");
                System.out.println("firebaseApp="+firebaseApp);
            } catch (IllegalStateException e) {
                firebaseApp = FirebaseApp.initializeApp(options, "other");
            }
            return firebaseApp;
        } catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }


    //Check firebase authentication token
    protected boolean validateFirebaseToken(String token) {

        FirebaseApp firebaseApp = getApp();

        if (firebaseApp == null) return false;

        FirebaseAuth instance = FirebaseAuth.getInstance(firebaseApp);
        System.out.println("instance="+instance);
        //System.out.println(token);
        try {
            FirebaseToken firebaseToken = instance.verifyIdToken(token);
            // verify token successfully
            return firebaseToken != null;
        } catch (FirebaseAuthException e) {
            // verify token error
            System.out.println("verify token error");

            System.out.println(e.getMessage());
        }

        return false;

    }

    boolean sendNotification(String token, String title, String _message) {
//    Dio().post(
//      'https://fcm.googleapis.com/fcm/send',
//      options: Options(headers: <String, String>{
//        'Content-Type': 'application/json',
//        'Authorization': 'key=$serverToken',
//      }),
//      data: <String, dynamic>{
//        'notification': <String, dynamic>{
//          'body': 'this is a body from app',
//          'title': 'this is a title from app'
//        },
//        'priority': 'high',
//        'data': <String, dynamic>{
//          'click_action': 'FLUTTER_NOTIFICATION_CLICK',
//          'id': '1',
//          'status': 'done'
//        },
//        'to': token,
//      },
//    ).then((f){print(f.data.toString());});
        HashMap<String, Object> request = new HashMap<>();

        FirebaseApp firebaseApp = getApp();

        if (firebaseApp == null) return false;

        FirebaseMessaging messaging = FirebaseMessaging.getInstance(firebaseApp);


        Message message = Message.builder()
                .putData("click_action", "FLUTTER_NOTIFICATION_CLICK")
                .putData("id", String.valueOf(id++))
                .putData("status", "done")
                .setAndroidConfig(AndroidConfig.builder().setNotification(AndroidNotification.builder().setSound("default").setBody(_message).setTitle(title).build()).build())
                .setNotification(Notification.builder().setBody(_message).setTitle(title).build())
                .setToken(token)
                .build();

        try {
            messaging.send(message);
            return true;
        } catch (FirebaseMessagingException e) {
            System.out.println(e.getMessage());
            return false;
        }

    }

    private String sendPOSTRequest(HashMap<String, Object> data) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String serverToken = "AAAAg-FJSfc:APA91bHr7OgmwmcP401YFBJZK_hkeeSO2qbMHXZaJa7Zup9U8dZ8XQqlFnF_z5q5fa9wskRu4PNiK8IMn0lYBjxJgi8srcafC1Mc-p2GU6T8v5kAQKvjwZoDJ_R0PVCvfroX09muIwln";
            headers.set("Authorization", "key=" + serverToken);

            HttpEntity entity = new HttpEntity<>(data, headers);
            String firebaseUrl = "https://fcm.googleapis.com/fcm/send";
            String answer = restTemplate.postForObject(firebaseUrl, entity, String.class);
            System.out.println(answer);
            return answer;
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    /**
     * 获取合法ip地址
     * @param request
     * @return
     */
    public static String getRealIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");//squid 服务代理
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");//apache服务代理
        }
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");//weblogic 代理
        }

        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");//有些代理
        }

        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP"); //nginx代理
        }

        /*
         * 如果此时还是获取不到ip地址，那么最后就使用request.getRemoteAddr()来获取
         * */
        if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            if (StringUtils.equals(ip, LOCAL_IP) || StringUtils.equals(ip, DEFAULT_IP)) {
                //根据网卡取本机配置的IP
                InetAddress iNet = null;
                try {
                    iNet = InetAddress.getLocalHost();
                } catch (UnknownHostException e) {
                }
                ip = iNet.getHostAddress();
            }
        }//对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        //"***.***.***.***".length() = 15
        if(!StringUtils.isEmpty(ip) && ip.length()> DEFAULT_IP_LENGTH){
            if(ip.indexOf(",") > 0){
                ip = ip.substring(0,ip.indexOf(","));
            }
        }
        return ip;
    }

    /**
     * 获取IP地址
     * @param request
     * @return
     */
    protected String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            // 多次反向代理后会有多个IP值，第一个为真实IP。
            int index = ip.indexOf(',');
            if (index != -1) {
                return ip.substring(0, index);
            }
            else {
                return ip;
            }
        }
        else {
            return request.getRemoteAddr();
        }
    }

}
