package com.example.afrishop_v3.quartz;


import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.util.HttpClientUtil;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @Auther: wudepeng
 * @Date: 2020/04/26
 * @Description:订单定时任务
 */
@Component
public class OrderTask {
    private static Logger logger = LoggerFactory.getLogger(OrderTask.class);
    private final TbCfOrderRepository orderRepository;
    private final UserRepository userRepository;

    private final TbCfItemOrderRepository itemOrderRepository;


    private final TbCfToicouponRepository toicouponRepository;

    private final TbCfAddressRepository addressRepository;


    private final TbCfItemSkuRepository itemSkuRepository;

    private final TbCfStationItemRepository stationItemRepository;

    private final TbCfDescripitonRepository descripitonRepository;

    private final TbCfPlatformOrderRepository platformOrderRepository;

    @Value("${logistics.track}")
    private String TRACK_API;

    @Value("${logistics.sign}")
    private String SIGN_API;

    @Value("${logistics.stock}")
    private String STOCK_API;

    @Value("${logistics.user}")
    private String USER_NO;

    @Value("${logistics.token}")
    private String TOKEN;

    @Value("${logistics.add_order}")
    private String ADD_ORDER_API;

    private final Lock lock = new ReentrantLock();

    public OrderTask(TbCfOrderRepository orderRepository, UserRepository userRepository1, TbCfItemOrderRepository itemOrderRepository, TbCfToicouponRepository toicouponRepository, UserRepository userRepository, TbCfAddressRepository addressRepository, TbCfItemSkuRepository itemSkuRepository, TbCfStationItemRepository stationItemRepository, TbCfDescripitonRepository descripitonRepository, TbCfPlatformOrderRepository platformOrderRepository) {
        this.orderRepository = orderRepository;
        this.userRepository = userRepository1;
        this.itemOrderRepository = itemOrderRepository;
        this.toicouponRepository = toicouponRepository;
        this.addressRepository = addressRepository;
        this.itemSkuRepository = itemSkuRepository;
        this.stationItemRepository = stationItemRepository;
        this.descripitonRepository = descripitonRepository;
        this.platformOrderRepository = platformOrderRepository;
    }

    /**
     * 将超时（24小时）未付款的订单释放库存
     */
    @Scheduled(cron = "0 0 0-23 * * ?")
    public void orderReleaseStock() throws ExecutionException, InterruptedException {

        ExecutorService executorService = Executors.newFixedThreadPool(20);
        //查询超时未支付的订单
        List<TbCfOrder> orderList = new ArrayList<>();
        for (int i = 0; i < 20; i++) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.DATE, -1);
            Date realDate = cal.getTime();
            Future<List<TbCfOrder>> orders = executorService.submit(() ->
                    orderRepository.findAllByOrderTimeLessThanAndOrderStatus(realDate, 10));

            orderList = orders.get();
            System.err.println(orderList);
        }

        for (TbCfOrder order : orderList) {
            //关闭交易订单
            //1.修改订单状态 ## 2.修改订单详情状态
//            order.setOrderStatus(OrderStatusEnum.CLOSE.getValue()); （订单超时关闭）
//            orderRepository.save(order);
            List<TbCfItemOrderR> orderDetailList = itemOrderRepository.findAllByOrderId(order.getOrderId());
            for (TbCfItemOrderR orderDetail : orderDetailList) {
                //订单关闭
//                orderDetail.setOrderStatus(OrderStatusEnum.CLOSE.getValue()); （订单详情超时关闭）
//                itemOrderRepository.save(orderDetail);
                logger.info("商品释放库存。。。");
                //释放库存
                Optional<TbCfItemSkus> skuOptional = itemSkuRepository.findFirstByItemId(orderDetail.getItemId());
                if (skuOptional.isPresent()) {

                    TbCfItemSkus item = skuOptional.get();
                    Optional<TbCfStationItem> byId = stationItemRepository.findById(orderDetail.getItemId());
                    System.out.println("释放数量：" + orderDetail.getItemNum());
                    if (byId.isPresent()) {
                        TbCfStationItem tbCfStationItem = byId.get();
                        System.out.println("商品库存：" + tbCfStationItem.getItemCount());
                        tbCfStationItem.setItemCount(tbCfStationItem.getItemCount() + orderDetail.getItemNum());
                    }
                    System.out.println("商品sku库存：" + item.getSkuCount());
                    item.setSkuCount(item.getSkuCount() + orderDetail.getItemNum());
                    itemSkuRepository.save(item);
                }
            }
            //释放优惠券
            if (!StringUtils.isBlank(order.getCouponId())) {
                Optional<TbCfToicoupon> cfToicouponOptional = toicouponRepository.findById(order.getCouponId());
                if (cfToicouponOptional.isPresent()) {
                    TbCfToicoupon coupon = cfToicouponOptional.get();
                    coupon.setEnableFlag(1);
                    toicouponRepository.save(coupon);
                }
            }
        }

    }

    /**
     * ##定时任务：每隔一小时向意境通推送订单
     * ##（已代购的订单&&物流状态为10的）
     */
    @Scheduled(cron = "0 0 0-23 * * ?")
    public void addOrderToYJT() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        List<Future<List<TbCfPlatformOrder>>> futureList = new ArrayList<>();
        for (int i = 0; i < 20; i++) {
            //查询已经代购的订单明细
            Future future = executorService.submit(() -> platformOrderRepository.findAllByLogisticsStatus(10));
            futureList.add(future);
        }
        futureList.forEach(order -> {
            if (!order.isDone()) {
                try {
                    List<TbCfPlatformOrder> list = order.get();
                    addOrderToYJT(list);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

    }

    //推送订单至意境通平台
    public void addOrderToYJT(List<TbCfPlatformOrder> orderList) throws IOException {
//        try {
        for (TbCfPlatformOrder platformOrder : orderList) {
            //查询用户信息
            Optional<TbCfOrder> orderOptional = orderRepository.findById(platformOrder.getOrderId());

            if (!orderOptional.isPresent()) return;

            TbCfOrder order = orderOptional.get();


            Optional<TbCfUserInfo> userInfoOptional = userRepository.findById(order.getUserId());

            if (!userInfoOptional.isPresent()) return;

            TbCfUserInfo user = userInfoOptional.get();

            Optional<TbCfItemOrderR> itemOrderOptional = itemOrderRepository.findById(platformOrder.getRelativeId());


            //封装请求参数
            Map<String, Object> paramMap = new HashMap<>();
            //账号号码
            paramMap.put("user_no", USER_NO);
            //账号TOKEN
            paramMap.put("token", TOKEN);
            //快递单号（后续用来查询物流轨迹的唯一标识）
            paramMap.put("orderNo", filterParam(platformOrder.getPExpressNumber()));
            //用户ID
            paramMap.put("user_id", filterParam(platformOrder.getUserId()));

            //##用户相关##
            Map<String, String> userMap = new HashMap<>();
            //用户编号
            userMap.put("userNo", filterParam(user.getUserNo()));
            //用户名
            userMap.put("userName", filterParam(user.getNick()));
            //手机号
            userMap.put("phone", user.getPhone() == null ? null : user.getPhone().substring(1));
            paramMap.put("user_array", userMap);

            //##订单相关##
            Map<String, Object> orderMap = new HashMap<>();
            //订单ID
            orderMap.put("orderId", platformOrder.getRelativeId());
            //下单号码
            orderMap.put("deliveryPhone", filterParam(order.getDeliveryPhone()));
            //下单地址
            orderMap.put("deliveryAddress", filterParam(order.getDeliveryAddress()));
            //下单人
            orderMap.put("deliveryName", filterParam(order.getDeliveryName()));
            //国家 默认赞比亚
            orderMap.put("country", "Zambia");

            //##商品相关##
            List<Map<String, Object>> itemDetailList = new ArrayList<>();
            String itemTitle = null;//商品名
            BigDecimal itemPrice = null;//商品价格
            // String descripitionName = platformOrder.getTemplateTitle();//报关品名
            if ("2".equals(order.getOrderSource().toString())) {
                //PC官网订单
//                    ItemVo item = tbCfItemSkusDao.queryItemDetail(platformOrder.getItemId());
//                    itemTitle = item.getItemName();
//                    itemPrice = item.getSkuPrice();
            } else {
                //app or 移动端订单
                Optional<TbCfStationItem> byId = stationItemRepository.findById(platformOrder.getItemId());
                if (byId.isPresent()) {
                    itemTitle = byId.get().getItemName();
                    itemPrice = byId.get().getItemPrice();
                }
            }
            Map<String, Object> itemMap = new HashMap<>();
            //商品名称
            itemMap.put("itemTitle", filterParam(itemTitle));
            //购买数量
            itemMap.put("itemNum", itemOrderOptional.isPresent() ? itemOrderOptional.get().getItemNum() : 1);
            //商品价格
            itemMap.put("itemPrice", itemPrice);
            //品名
            //  itemMap.put("descripitionName", filterParam(descripitionName));
            itemDetailList.add(itemMap);

            orderMap.put("itemDetailList", itemDetailList);
            paramMap.put("order_info", orderMap);

            //发送请求
            System.err.println(paramMap);
            String body = HttpClientUtil.sendPostWithBodyParameter(ADD_ORDER_API, paramMap);
            JSONObject jsonObject = JSONObject.fromObject(body);
            System.err.println(jsonObject);
            logger.info("订单号[" + order.getOrderNo() + "]开始下单，时间：" + new Date());
            logger.info(String.valueOf(jsonObject));
            if ("0".equals(jsonObject.getString("error"))) {
                //下单成功
                lock.lock();
                // PlatformOrderVo platformOrderVo = tbCfPlatformOrderDao.queryObject(platformOrder.getRelativeId());
                platformOrder.setLogisticsStatus(20);
                platformOrderRepository.save(platformOrder);
                lock.unlock();
            }
        }
//        } catch (Exception e) {
//            //发生异常
//            logger.error("对接意境通下单发生异常：" + e);
//        }

    }
//
//    /**
//     * 将已发货的订单信息传输至易境通平台
//     */
//    @Scheduled(cron = "0 0 0-23 * * ?")
//    public void addOrdersToYJT() throws Exception {
//        try {
//            ExecutorService executorService = Executors.newFixedThreadPool(20);
//            List<Future> list = new ArrayList<>();
//            for (int i = 0; i < 20; i++) {
//                Future future = executorService.submit(() -> tbCfOrderDao.queryLogisticsOrder());
//                list.add(future);
//            }
//            for (Future future : list) {
//                if (!future.isDone()) {
//                    List<TbCfOrderEntity> orderList = (List<TbCfOrderEntity>) future.get();
//                    for (TbCfOrderEntity order : orderList) {
//                        add_order(order);
//                    }
//                }
//            }
//        } catch (Exception e) {
//            logger.error("物流下单发生异常：" + e.toString());
//        }
//
//    }
//
//    //添加订单
//    public void add_order(TbCfOrderEntity order) {
//
//        try {
//            TbCfUserInfoEntity user = tbCfUserInfoDao.queryObject(order.getUserId());
//            TbCfAddressEntity address = tbCfAddressDao.queryObject(user.getDefaultAddressId());
//            TbCfAddressEntity addressEntity = tbCfAddressDao.queryObject(order.getDeliveryAddressId());
//
//            //封装请求参数
//            Map<String, Object> paramMap = new HashMap<>();
//            paramMap.put("user_no", USER_NO);
//            paramMap.put("token", TOKEN);
//            paramMap.put("orderNo", filterParam(order.getOrderNo()));
//            paramMap.put("user_id", filterParam(order.getUserId()));
//            //用户相关
//            Map<String, String> userMap = new HashMap<>();
//            userMap.put("userNo", filterParam(user.getUserNo()));
//            userMap.put("userName", filterParam(user.getNick()));
//            userMap.put("phone", user.getPhone() == null ? null : user.getPhone().substring(1));
//            if (address != null) {
//                userMap.put("defaultAddressName", filterParam(address.getAddressDetail()));
//            } else {
//                userMap.put("defaultAddressName", null);
//            }
//            paramMap.put("user_array", userMap);
//            //订单相关
//            Map<String, Object> orderMap = new HashMap<>();
//            orderMap.put("orderId", order.getOrderId());
//            if (addressEntity != null) {
//                orderMap.put("deliveryPhone", filterParam(addressEntity.getPhone()));
//                orderMap.put("deliveryAddress", filterParam(addressEntity.getAddressDetail()));
//                orderMap.put("deliveryName", filterParam(addressEntity.getDeliveryName()));
//            } else {
//                orderMap.put("deliveryPhone", null);
//                orderMap.put("deliveryAddress", null);
//                orderMap.put("deliveryName", null);
//            }
//            orderMap.put("country", "Zambia");
//            //商品相关
//            List<TbCfItemOrderREntity> orderDetailList = tbCfItemOrderRDao.queryByOrderId(order.getOrderId());
//
//            List<Map<String, Object>> itemDetailList = new ArrayList<>();
//            for (TbCfItemOrderREntity orderDetail : orderDetailList) {
//                String itemTitle = null;
//                BigDecimal itemPrice = null;
//                String descripitionName = "";
//                if ("2".equals(order.getOrderSource())) {
//                    ItemVo item = tbCfItemSkusDao.queryItemDetail(orderDetail.getItemId());
//                    itemTitle = item.getItemName();
//                    itemPrice = item.getSkuPrice();
//                    descripitionName = item.getDescName();
//
//                } else {
//                    TbCfItemDetailEntity item = tbCfItemDetailDao.queryObject(orderDetail.getItemId());
//                    if (item != null) {
//                        itemTitle = item.getItemTitle();
//                        itemPrice = item.getItemPrice();
//                        if (!StringUtils.isBlank(item.getGoodsId())) {
//                            TbCfDescripitonEntity desc = tbCfDescripitonDao.queryPostage(item.getGoodsId());
//                            descripitionName = desc.getDescripitionName();
//                        }
//                    }
//
//                }
//                Map<String, Object> itemMap = new HashMap<>();
//                itemMap.put("itemTitle", filterParam(itemTitle));
//                itemMap.put("itemNum", orderDetail.getItemNum());
//                itemMap.put("itemPrice", itemPrice);
//                itemMap.put("descripitionName", filterParam(descripitionName));
//                itemDetailList.add(itemMap);
//            }
//            orderMap.put("itemDetailList", itemDetailList);
//            paramMap.put("order_info", orderMap);
//            //发送请求
//            String body = HttpClientUtil.sendPostWithBodyParameter(ADD_ORDER_API, paramMap);
//            JSONObject jsonObject = JSONObject.fromObject(body);
//            logger.info("订单号[" + order.getOrderNo() + "]开始下单，时间：" + new Date());
//            logger.info(String.valueOf(jsonObject));
//            if ("0".equals(jsonObject.getString("error"))) {
//                //下单成功
//                lock.lock();
//                order.setLogisticsStatus(20);
//                tbCfOrderDao.update(order);
//                lock.unlock();
//            }
//        } catch (Exception e) {
//            logger.error("订单号[" + order.getOrderNo() + "]下单发生异常：" + e.toString());
//        }
//
//    }

    //过滤空参数
    public String filterParam(String param) {
        if (StringUtils.isBlank(param)) {
            return null;
        }
        return param;
    }

}


