package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 virtual_user
 *
 * @author lipengjun
 * @date 2021-01-27 10:21:45
 */
@Entity
@Data
public class VirtualUser implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 虚拟用户ID
     */
    @Id
    private String id;
    /**
     * 虚拟账号
     */
    private String account;
    /**
     * 昵称
     */
    private String nick;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 状态 0：已删除 1：正常
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：虚拟用户ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：虚拟用户ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：虚拟账号
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * 获取：虚拟账号
     */
    public String getAccount() {
        return account;
    }
    /**
     * 设置：昵称
     */
    public void setNick(String nick) {
        this.nick = nick;
    }

    /**
     * 获取：昵称
     */
    public String getNick() {
        return nick;
    }
    /**
     * 设置：头像
     */
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    /**
     * 获取：头像
     */
    public String getAvatar() {
        return avatar;
    }
    /**
     * 设置：状态 0：已删除 1：正常
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取：状态 0：已删除 1：正常
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
