package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Formula;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;

@Entity
@Getter
@Setter
public class Tag extends Model {
    @ManyToOne(cascade = CascadeType.ALL)
    @JsonProperty(value = "item")
    protected TbCfStationItem stationItem;

    protected String tagName;

    @Formula(value = "(SELECT IFNULL(COUNT(p.id),0) FROM content_tag p WHERE p.tag_id=id)")
    protected int posts;

    public String getTagName() {
        return tagName;
    }

    public TbCfStationItem getStationItem() {
        return stationItem;
    }

    public void setStationItem(TbCfStationItem stationItem) {
        this.stationItem = stationItem;
    }

}
