package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Formula;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Entity
@Getter
@Setter
@Table(name = "post_data")
public class Post extends Model {
    @ManyToOne()
    private TbCfUserInfo userInfo;

    private String title;
    @Transient
    private String tags;
    @Transient
    private String hashtags;

    private String description;

    private String category;

    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM post_like_v2 c WHERE c.post_id=id)")
    private int likes;
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM comment c WHERE c.post_id=id)")
    private int comments;
    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM visit c WHERE c.post_id=id)")
    private int visits;

    @Transient
    public boolean liked = false;

    @Transient @JsonIgnore
    public boolean retrieveAll = false;


    @OneToMany(mappedBy = "post",cascade = CascadeType.ALL)
    public List<Content> contentList = new ArrayList<>();


    @JsonIgnore
    @OneToMany(mappedBy = "post",cascade = CascadeType.ALL)
    public List<PostHashtag> hashtagList = new ArrayList<>();


    public String getTags() {
        return tags;
    }

    public String getUsername() {
        return userInfo != null ? userInfo.display() : "";
    }

    public String getUserId(){
        return userInfo != null ? userInfo.getUserId() : "";
    }

    public String getAvatar() {
        return userInfo != null ? userInfo.getAvatar() : "";
    }

    @JsonIgnore
    public TbCfUserInfo getRealUser() {
        return userInfo;
    }


    public TbCfUserInfo getUser() {
        return retrieveAll ? userInfo : null;
    }


    public String getHashtags() {
        return hashtags;
    }

    public void setUser(TbCfUserInfo user) {
        this.userInfo = user;
    }

    public void setTitle(String title) {
        this.title = title;
    }


    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public String getTitle() {
        return title;
    }

    public String getCategory() {
        return category;
    }


    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty
    public Date date() {
        return createDate;
    }


    @JsonProperty
    public List<Hashtag> hashtags() {
        return retrieveAll ? hashtagList.stream().map(PostHashtag::getHashtag).collect(Collectors.toList()) : new ArrayList<>();
    }


    @JsonProperty
    public List<Map<String,Object>> items() {
        return contentList.stream().map(Content::getMap).collect(Collectors.toList());
    }


    public TbCfUserInfo getUserInfo() {
        return null;
    }

    public List<Content> getContentList() {
        return retrieveAll ? contentList : new ArrayList<>();
    }

}
