package com.example.afrishop_v3.controllers;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfPlatformOrder;
import com.example.afrishop_v3.repository.TbCfExpressTemplateRepository;
import com.example.afrishop_v3.repository.TbCfPlatformOrderRepository;
import com.example.afrishop_v3.util.HttpClientUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@RestController
@RequestMapping("/logistics")
public class LogisticsController {


    @Value("${logistics.track}")
    private String TRACK_API;

    @Value("${logistics.sign}")
    private String SIGN_API;

    @Value("${logistics.stock}")
    private String STOCK_API;

    @Value("${logistics.user}")
    private String USER_NO;

    @Value("${logistics.token}")
    private String TOKEN;

    private final TbCfPlatformOrderRepository repository;
    private final TbCfExpressTemplateRepository expressTemplateRepository;
    private static Logger logger = LoggerFactory.getLogger(LogisticsController.class);

    public LogisticsController(TbCfPlatformOrderRepository repository, TbCfExpressTemplateRepository expressTemplateRepository) {
        this.repository = repository;
        this.expressTemplateRepository = expressTemplateRepository;
    }

    @GetMapping("/getOrderLogistics/{orderDetailId}")
    public Result getOrderLogistics(@PathVariable("orderDetailId") String orderDetailId) {
        Result<JSONObject> result = new Result<>();
        try {
            /**
             * {
             * 	"user_no":"shd806",
             * 	"token":"d44426bd5b64dd2",
             * 	"data":[{"order_no":"75319701383402C"}]
             * }
             */
            Optional<TbCfPlatformOrder> optional = repository.findById(orderDetailId);
            //还未发货
            if (!optional.isPresent()) {
                result.setCode(ResultCodeEnum.QUERY_ERROR.getCode());
                result.setMessage("No logistics information");
                return result;
            }
            TbCfPlatformOrder platformOrder = optional.get();
            //封装请求参数
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("user_no", USER_NO);
            paramMap.put("token", TOKEN);
            Map<String, String> orderNoMap = new HashMap<>();
            orderNoMap.put("order_no", platformOrder.getPExpressNumber());//快递单号
            List<Map<String, String>> list = new ArrayList<>();
            list.add(orderNoMap);
            paramMap.put("data", list);
            //发送请求
            String body = HttpClientUtil.sendPostWithBodyParameter(TRACK_API, paramMap);
            //返回json数据给前端
            result.setData(JSONObject.parseObject(body));
            JSONObject jsonObject = JSONObject.parseObject(body);
            JSONArray content = jsonObject.getJSONArray("content");
            for (int i = 0; i < content.size(); i++) {
                JSONObject object = content.getJSONObject(i);
                String data = object.getString("data");
                System.out.println(data);
                if (StringUtils.isBlank(data)) {
                    result.setCode(ResultCodeEnum.QUERY_ERROR.getCode());
                    result.setMessage("No logistics information");
                    logger.info("No logistics information");
                    logger.info(orderDetailId);
                    return result;
                }
            }
            result.setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @GetMapping("/freeShippingThreshold")
    public Result freeShippingThreshold(){

        return new Result<>(expressTemplateRepository.findFirstByIsDefault(1));
    }
}
