package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_recommend
 *
 * @author lipengjun
 * @date 2020-01-13 15:00:49
 */
@Entity
@Data
@Where(clause = "del_flag=1")
public class TbCfRecommend{

    /**
     * 推荐ID
     */
    @Id
    private String id;
    /**
     * 热门推荐
     */
    private String recommend;
    /**
     * 备注
     */
    private String remark;
    /**
     * 删除标志
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createtime;
    /**
     * 更新时间
     */
    private Date updatetime;

    /**
     * 设置：推荐ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：推荐ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：热门推荐
     */
    public void setRecommend(String recommend) {
        this.recommend = recommend;
    }

    /**
     * 获取：热门推荐
     */
    public String getRecommend() {
        return recommend;
    }
    /**
     * 设置：备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取：备注
     */
    public String getRemark() {
        return remark;
    }
    /**
     * 设置：删除标志
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标志
     */
    public Integer getDelFlag() {
        return delFlag;
    }
    /**
     * 设置：创建时间
     */
    public void setCreatetime(Date createtime) {
        this.createtime = createtime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreatetime() {
        return createtime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdatetime(Date updatetime) {
        this.updatetime = updatetime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdatetime() {
        return updatetime;
    }
}
