package com.example.afrishop_v3.models;

import com.example.afrishop_v3.util.IdUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.util.Date;

@MappedSuperclass
abstract class Model {
    @Id
    @JsonProperty
    @Column(length = 64)
    protected String id;

    @JsonIgnore
    Date createDate = new Date();

    Model(){
        setId(IdUtil.createIdbyUUID());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public String createdBy;

    @JsonIgnore
    public Date updateDate = new Date();

    @JsonIgnore
    public String updatedBy;

    private int version;

    @JsonIgnore
    public boolean archived;

    @JsonIgnore
    public String archivedBy;

    @JsonIgnore
    public Date archivedDate = new Date();

    public void clearId(){
        id = null;
    }

}
