package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 advertisement
 *
 * @author lipengjun
 * @date 2020-09-28 17:54:01
 */
@Data
@Entity
public class Advertisement {
    private static final long serialVersionUID = 1L;

    /**
     * 广告投放ID
     */
    @Id
    private String id;

    private String itemIds;
    /**
     * 广告名
     */
    private String adName;
    /**
     * 广告链接
     */
    private String adLink;
    /**
     * banner图
     */
    private String picture;
    /**
     * 状态 0：已删除 1：活动进行中 2：活动已关闭 3：活动已结束
     */
    private Integer status;
    /**
     * 活动开始时间
     */
    private Date startTime;
    /**
     * 活动结束时间
     */
    private Date endTime;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 备注
     */
    private String remark;


    public String getId() {
        return id;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
