package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.OssUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Base64;
import com.google.api.client.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/discover/post")
public class PostController {
    @Value("${upload.api}")
    private String api;

    private final PostRepository repository;
    private final LikeRepository likeRepository;
    private final CommentRepository commentRepository;
    private final PostTagRepository postTagRepository;
    private final ContentRepository contentRepository;
    private final UserRepository userRepository;
    private final VisitRepository visitRepository;
    private final BonusRepository bonusRepository;
    private final HashtagRepository hashtagRepository;
    private final TbCfStationItemRepository itemRepository;
    private final TagRepository tagRepository;
    private final ComplainRepository complainRepository;
    private final PostHashtagRepository postHashtagRepository;
    private final AuthenticationUser user;
    private static Logger logger = LoggerFactory.getLogger(PostController.class);


    public PostController(PostRepository repository, LikeRepository likeRepository, CommentRepository commentRepository, PostTagRepository postTagRepository, ContentRepository contentRepository, UserRepository userRepository, VisitRepository visitRepository, BonusRepository bonusRepository, HashtagRepository hashtagRepository, TbCfStationItemRepository itemRepository, TagRepository tagRepository, ComplainRepository complainRepository, PostHashtagRepository postHashtagRepository, AuthenticationUser user) {
        this.repository = repository;
        this.likeRepository = likeRepository;
        this.commentRepository = commentRepository;
        this.postTagRepository = postTagRepository;
        this.contentRepository = contentRepository;
        this.userRepository = userRepository;
        this.visitRepository = visitRepository;
        this.bonusRepository = bonusRepository;
        this.hashtagRepository = hashtagRepository;
        this.itemRepository = itemRepository;
        this.tagRepository = tagRepository;
        this.complainRepository = complainRepository;
        this.postHashtagRepository = postHashtagRepository;
        this.user = user;
    }

    @GetMapping("/listPosts")
    public List<Post> postList(@RequestParam(value = "userId", required = false) String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {

        Optional<TbCfUserInfo> byId = id == null ? Optional.empty() : userRepository.findById(id);
        List<Post> postList;
        PageRequest of = PageRequest.of(pageNo, pageSize);
        postList = byId.map(tbCfUserInfo -> repository.findAllByOrderByIdDesc(tbCfUserInfo, of).toList()).orElseGet(() -> repository.findAllByOrderByCreateDateDesc(of).toList());
        return id == null ? postList : postList(postList, id);
    }

    @GetMapping("/listPostsByHashtag/{tag}")
    public List<Post> postListByTag(@PathVariable(value = "tag") String tag, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        //Optional<User> byId = userRepository.findById(id);
        //if( !byId.isPresent() ) return new ArrayList<>();

        Optional<Hashtag> byName = hashtagRepository.findFirstByName(tag);

        if (!byName.isPresent()){
            logger.info("Hashtag not found");
            return new ArrayList<>();
        }
        //return found result
        return repository.findAllByOrderByCreateDateDesc(byName.get(), PageRequest.of(pageNo, pageSize)).toList();
    }

    @GetMapping("/listPostsLiked/{userId}")
    public List<Post> postListLiked(@PathVariable(value = "userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        Optional<TbCfUserInfo> byId = userRepository.findById(id);
        if (!byId.isPresent()) return new ArrayList<>();
        List<Post> postList = repository.findAllByOrderByCreateDateDesc(byId.get(), PageRequest.of(pageNo, pageSize)).toList();
        return postList(postList, id);
    }


    @GetMapping("/visit/{postId}")
    public Visit visitPage(@PathVariable(value = "postId") String id) {
        Optional<Post> byId = repository.findById(id);
        if (byId.isPresent()) {
            Post post = byId.get();
            return visitPost(post);
        }
        return null;
    }


    private Visit visitPost(Post post) {
        Visit visit = new Visit();
        visit.setPost(post);
        return visitRepository.save(visit);
    }

    @PostMapping(value ="/saveComplain")
    public Result saveProduct(@ModelAttribute("Complain") Complain complain){

        TbCfUserInfo user = this.user.user();

        if(complainRepository.existsByUserInfoAndPost(user,complain.getPost())){
            //Complain already exists
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Already complained");
        }

        String userId = complain.userId();

        if( userId == null ){
            //return if user not found
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"User not found");
        }

        Optional<TbCfUserInfo> byId = userRepository.findById(userId);

        if( byId.isPresent() ){
            TbCfUserInfo info = byId.get();
            if( "8AD1dO".equals(info.getCode()) || "xdEmqd".equals(info.getCode()) || "MdjDn0".equals(info.getCode())){
                del(complain.postId());
                logger.warn("Post automatically deleted by :");
                logger.warn(info.display());
                return new Result<>(complain);
            }
        }

        complain.setUserInfo(user);

        complainRepository.save(complain);

        return new Result();
    }



    @PostMapping(value = "/repost/{userId}/{postId}")
    public Optional<Post> saveRePost(@PathVariable("userId") String id, @PathVariable("postId") String postId) {
        Optional<TbCfUserInfo> byId = userRepository.findById(id);
        Optional<Post> optional = repository.findById(postId);
        if (byId.isPresent() && optional.isPresent()) {
            Post post = optional.get();
            List<PostHashtag> hashtagList = new ArrayList<>(post.hashtagList);
            List<Content> contentList = new ArrayList<>(post.contentList);
            //Declare new post to be copied to
            Post nPost = new Post();
            nPost.setUser(byId.get());
            nPost.setTitle(post.getTitle());
            if(post.getDescription() != null) nPost.setDescription(post.getDescription());
            nPost.setCategory(post.getCategory());
            nPost = repository.save(nPost);
            Post finalNPost = nPost;
            //Copy hashtags
            hashtagList.forEach(f -> {
                PostHashtag hashtag = new PostHashtag();
                hashtag.setPost(finalNPost);
                hashtag.setHashtag(f.getHashtag());
                postHashtagRepository.save(hashtag);
            });
            //Copy post contents
            contentList.forEach(f -> {
                List<ContentTag> tagList = new ArrayList<>(f.contentTags);
                Content content = new Content();
                content.setPost(finalNPost);
                content.setThumbnail(f.getThumbnail());
                content.setImage(f.isImage());
                content.setSize(f.getSize());
                content.setContent(f.getContent());
                content = contentRepository.save(content);
                Content finalContent = content;
                tagList.forEach(x -> {
                    ContentTag contentTag = new ContentTag();
                            contentTag.setContent(finalContent);
                            contentTag.setX(x.getX());
                            contentTag.setY(x.getY());
                            contentTag.setTag(x.getTag());
                            postTagRepository.save(contentTag);
                        });

            });
            return Optional.of(nPost);

        }
        return Optional.empty();
    }


    //Check if post is liked by user
    private List<Post> postList(List<Post> postList, String userId) {
        for (Post post : postList) {
            post.liked = likeRepository.existsByUserInfo_UserIdAndPost_Id(userId, post.getId());
        }

        return postList;
    }

    //List posts for specific user
    @GetMapping("/listPostsByUser/{userId}")
    public List<Post> postListBy(@PathVariable(value = "userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        List<Post> postList = repository.findAllByUserInfoUserIdOrderByCreateDateDesc(id, PageRequest.of(pageNo, pageSize)).toList();
        return this.postList(postList, id);
    }
    //Search post
    @GetMapping("/searchPost/{query}")
    public List<Post> postListSearchBy(@PathVariable(value = "query") String query, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByDescriptionContainingOrTitleContainingOrUserInfoNickContaining(query,query,query, PageRequest.of(pageNo, pageSize)).toList();
        //return this.postList(postList, id);
    }

    @GetMapping("/delete/post/{postId}")
    @Transactional //manage transaction for many queries
    public String del(@PathVariable("postId") String id) {
        try {
            //Delete all chained information to the post
            likeRepository.removeByPost_Id(id);
            commentRepository.removeByPost_Id(id);
            postTagRepository.removeByPost_Id(id);
            visitRepository.removeByPost_Id(id);
            bonusRepository.removeByPost_Id(id);
            contentRepository.removeByPost_Id(id);
            postHashtagRepository.removeByPost_Id(id);
            repository.deleteById(id);
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return "deleted";
    }

    @Transactional()
    @PostMapping("/upload")
    public List<String> handleFileUpload(@RequestParam("files") MultipartFile[] files, @RequestParam("thumbs") MultipartFile[] thumbs, @ModelAttribute("Post") Post ePost) {
        logger.info("picture:"+files);
        logger.info("thumbs:"+thumbs);
        Post post = new Post();
        TbCfUserInfo user = this.user.user();
        post.setUser(user);
        post.setDescription(ePost.getDescription());
        post.setTitle(ePost.getTitle());
        //repository.save(post);
        List<String> list = new ArrayList<>();
        List<String> thumbList = new ArrayList<>();

        if (thumbs != null) {
            //Check if has video thumbs
            for (MultipartFile file : thumbs) {
//                StringBuilder sb = new StringBuilder();
//                sb.append("data:image/png;base64,");
//                sb.append(StringUtils.newStringUtf8(Base64.encodeBase64(file.getBytes())));
//                Path store = storageService.store(file);
//                String string = MvcUriComponentsBuilder.fromMethodName(FileUploadController.class,
//                        "serveFile", store.getFileName().toString()).build().toUri().toString();
                String string;
                try {
                    string = OssUtil.upload(file,"discover");
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                    logger.debug(e.getMessage());
                    continue;
                }
                thumbList.add(string);
            }
        }
        if (files != null) {
            //Upload files list
            for (MultipartFile file : files) {
                //StringBuilder sb = new StringBuilder();
               // sb.append("data:image/png;base64,");
                //sb.append(StringUtils.newStringUtf8(Base64.encodeBase64(file.getBytes())));
//                Path store = storageService.store(file);
//                String string = MvcUriComponentsBuilder.fromMethodName(FileUploadController.class,
//                        "serveFile", store.getFileName().toString()).build().toUri().toString();
                String string;
                try {
                    string = OssUtil.upload(file,"discover");
                } catch (Exception e) {
                    logger.warn(e.getMessage());
                    continue;
                }
                list.add(string);
                Content content = new Content();
                content.setPost(post);
                content.setImage(true);
               // content.path = store.toFile().getAbsolutePath();
                content.setContent(string);
                content.setSize(file.getSize());
                post.contentList.add(content);
                //contentRepository.save(content);
            }
        }

        ObjectMapper mapper = new ObjectMapper();
        List<JsonTag> tags = null;
        List<Hashtag> hashtags = null;
        //read item tags and hashtags from json
        try {
            tags = mapper.readValue(ePost.getTags(), new TypeReference<List<JsonTag>>() {
            });
            hashtags = mapper.readValue(ePost.getHashtags(), new TypeReference<List<Hashtag>>() {
            });
        } catch (JsonProcessingException e) {
            System.out.println(e.getMessage());
            logger.warn(e.getMessage());
        }

        if (hashtags != null) {
            for (Hashtag hashtag : hashtags) {
                Optional<Hashtag> byName = hashtagRepository.findFirstByName(hashtag.getName());
                hashtag = hashtagRepository.existsByName(hashtag.getName()) && byName.isPresent() ?
                        byName.get() :
                        hashtag;
                PostHashtag postHashtag = new PostHashtag();
                postHashtag.setHashtag(hashtag);
                postHashtag.setPost(post);
                if( !postHashtagRepository.existsByHashtagNameAndPostId(hashtag.getName(),post.getId()) ) {
                    post.hashtagList.add(postHashtag);
                }
            }
        }

        try {

            if (tags != null) {
                int index = 0;
                int vid = 0;
                for (JsonTag jsonTag : tags) {
                    if (post.contentList.size() > index) {
                        Content content = post.contentList.get(index);
                        content.setImage(jsonTag.isImage());
                        if (!jsonTag.isImage()) {
                            if (vid < thumbList.size()) {
                                String s = thumbList.get(vid);
                                content.setThumbnail(s);
                                vid++;
                            }
                        }
                        //contentRepository.save(content);
                        for (Position position : jsonTag.list) {

                            Tag tag = position.getTag();

                            TbCfStationItem item = tag.getStationItem();

                            Optional<TbCfStationItem> itemOptional = itemRepository.findById(item.getItemId());

                            if (itemOptional.isPresent()) {
                                item = itemOptional.get();
                            } else {
                                //item = itemRepository.save(item);
                                logger.warn("Product not found");
                                logger.warn(item.getItemId());
                            }
                            tag.setStationItem(item);


                            ContentTag contentTag = new ContentTag();
                            if (!tagRepository.existsByTagName(tag.getTagName())) {
                                // tagRepository.save(tag);
                                logger.warn("Tag Not found");
                                logger.warn(tag.getTagName());
                            } else {
                                tag = tagRepository.findByTagName(tag.getTagName());
                            }
                            contentTag.setTag(tag);
                            contentTag.setX(position.getX());
                            contentTag.setY(position.getY());
                            contentTag.setContent(content);
                            content.contentTags.add(contentTag);
                        }
                        index++;
                    }
                }
            }
        }catch (Exception e){
            System.out.println(e.getMessage());
            logger.warn(e.getMessage());
        }
        //redirectAttributes.addFlashAttribute();

        try {
            repository.save(post);
        }catch (Exception e){
            logger.warn(e.getMessage());
            System.out.println(e.getMessage());
        }

        return list;
    }

}
