package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfAddress;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfAddressRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/address")
public class AddressController extends Controller {
    private final TbCfAddressRepository repository;
    private final UserRepository userRepository;
    private final AuthenticationUser user;

    public AddressController(TbCfAddressRepository repository, UserRepository userRepository, AuthenticationUser user) {

        this.repository = repository;
        this.userRepository = userRepository;
        this.user = user;
    }

    @GetMapping
    public Result<Iterable<TbCfAddress>> getUserInfoList() {
        Iterable<TbCfAddress> tbCfAddressVoList = repository.findAllByUserId(user.userId(), Sort.by(Sort.Order.desc("defaultFlag"), Sort.Order.asc("createTime")));
        return new Result<>(tbCfAddressVoList);
    }

    @PostMapping
    public Result addUserInfo(@RequestBody TbCfAddress address) {
        ResultCodeEnum e = ResultCodeEnum.VALIDATE_ERROR;
        String userId = user.userId();
        if (address == null)
            return new Result(e.getCode(), e.getDesc());
//        if (address.getAddress1() == null || address.getAddress1().trim().isEmpty())
//            return new Result(e.getCode(), "Address is required");
//        if (address.getDeliveryName() == null || address.getDeliveryName().trim().isEmpty())
//            return new Result(e.getCode(), "Delivery name is required");
//        if (address.getPhone() == null || address.getPhone().trim().isEmpty())
//            return new Result(e.getCode(), "Phone is required");
        if (repository.existsByAddressDetailAndUserId(address.getAddressDetail().trim(), userId))
            return new Result(e.getCode(), "Address already existed");


        //客户新增第一条地址，设置为默认
//        if (!repository.existsByUserId(userId)) {
//            address.setDefaultFlag(1);
//        }
//        address.setAddress1(address.getAddress1().trim());
        address.setAddressDetail(address.getAddressDetail().trim());
        address.setUserId(userId);
        address.setCreateTime(new Date());
        address.setAddressId(uid());
        address.setDefaultFlag(address.getDefaultFlag());

        TbCfAddress save = repository.save(address);

//        TbCfUserInfo user = this.user.user();
//
//        user.setAddress(address);
//        userRepository.save(user);

        configDefaultAddress(save.getAddressId());

        return new Result<>(save);
    }

    @GetMapping("/findAddressById/{id}")
    public Result findAddressById(@PathVariable("id") String id) {

        return new Result(repository.findById(id));
    }

    @PutMapping("/{addressId}")
    public Result editAddressInfo(@PathVariable("addressId") String addressId, @RequestBody TbCfAddress address) {

        ResultCodeEnum e = ResultCodeEnum.VALIDATE_ERROR;
        if (!repository.existsById(addressId))
            return new Result(e.getCode(), "Address doesn't exist");

        String userId = user.userId();
        if (address == null)
            return new Result(e.getCode(), e.getDesc());
//        if (address.getAddress1() == null || address.getAddress1().trim().isEmpty())
//            return new Result(e.getCode(), "Address is required");
//        if (address.getDeliveryName() == null || address.getDeliveryName().trim().isEmpty())
//            return new Result(e.getCode(), "Delivery name is required");
//        if (address.getPhone() == null || address.getPhone().trim().isEmpty())
//            return new Result(e.getCode(), "Phone is required");

        if (repository.existsByAddressDetailAndUserIdAndAddressIdIsNot(address.getAddressDetail().trim(), userId, addressId))
            return new Result(e.getCode(), "Address already existed");


        address.setAddressDetail(address.getAddressDetail().trim());
        address.setAddressId(addressId);
        address.setUpdateTime(new Date());
        address.setDefaultFlag(address.getDefaultFlag());
        address.setUserId(userId);
        address.setDefaultFlag(address.getDefaultFlag());
        TbCfAddress save = repository.save(address);
        configDefaultAddress(save.getAddressId());
        return new Result<>(save);
    }

    @DeleteMapping("/{addressId}")
    public Result deleteAddressInfo(@PathVariable("addressId") String addressId) {
        Optional<TbCfAddress> byId = repository.findById(addressId);
        if (byId.isPresent()) {
            TbCfAddress address = byId.get();

            TbCfUserInfo user = this.user.user();
            TbCfAddress cfAddress = user.getAddress();

            if (cfAddress != null && cfAddress.getAddressId().equals(address.getAddressId())) {
                user.setAddress(null);
                userRepository.save(user);
            }

            repository.delete(address);
            Integer count = repository.countAllByUserId(user.getUserId());
            if (count == 1) {
                repository.updateAddress(user.getUserId());
            }
        }
        return new Result<>();
    }

    @PutMapping(value = "/default/{addressId}")
    public Result configDefaultAddress(@PathVariable("addressId") String addressId) {
        Optional<TbCfAddress> byId = repository.findById(addressId);

        if (byId.isPresent()) {
            TbCfAddress address = byId.get();
            TbCfUserInfo user = this.user.user();


//            System.out.println("address1:" + address);


            repository.resetToDefaultAndAddressIdIsNot(user.getUserId(), addressId);

            address.setDefaultFlag(StateConstant.VALID);
            TbCfAddress save = repository.save(address);
            user.setAddress(address);
            userRepository.save(user);
            System.out.println("address2:" + save);

            return new Result(save);

        }

        return new Result<>().setCode(ResultCodeEnum.ERROR.getCode()).setMessage(ResultCodeEnum.ERROR.getDesc());
    }


    @GetMapping(value = "/default")
    public Result getDefaultAddress() {
//        TbCfAddress address = user.user().getAddress();
        if (user.userId() == null) {
            return new Result<>();
        }
        TbCfAddress address = repository.findFirstByUserIdAndDefaultFlag(user.userId(), StateConstant.VALID);
        return new Result<>(address, address == null ? ResultCodeEnum.SERVICE_ERROR.getCode() : ResultCodeEnum.SUCCESS.getCode(), "");
    }
}
